/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public final class FormatUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";

    private FormatUtils() {
    }

    public static Date toDate(String s, boolean includeTime) {
        String pattern = includeTime ? DATETIME_PATTERN : DATE_PATTERN;
        try {
            if (StringUtils.isNotBlank((String)s)) {
                return new SimpleDateFormat(pattern).parse(s);
            }
            return null;
        }
        catch (ParseException e) {
            throw new RuntimeException("The following value does not respect the date pattern " + pattern + ": " + s, e);
        }
    }

    public static String toString(Date d, boolean includeTime) {
        if (d != null) {
            return new SimpleDateFormat(includeTime ? DATETIME_PATTERN : DATE_PATTERN).format(d);
        }
        return null;
    }
}

