/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.updatecenter.api;

import org.json.simple.JSONObject;

/**
 * Information about Sonar.
 *
 * @author Evgeny Mandrikov
 */
public class Sonar implements Versioned {

  private final String version;

  public Sonar(String version) {
    this.version = version;
  }

  /**
   * @return Sonar version
   */
  public String getVersion() {
    return version;
  }

  /**
   * @return URL for downloading
   */
  public String getDownloadUrl() {
    return "http://dist.sonar.codehaus.org/sonar-" + getVersion() + ".zip";
  }

  public JSONObject toJsonObject() {
    JSONObject obj = new JSONObject();
    obj.put("version", getVersion());
    obj.put("downloadUrl", getDownloadUrl());
    return obj;
  }

}
