/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.i18n;

import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.sonar.test.TestUtils;
import org.sonar.test.i18n.BundleSynchronizedMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18nMatchers {
    private I18nMatchers() {
    }

    public static BundleSynchronizedMatcher isBundleUpToDate(String sonarVersion) {
        return new BundleSynchronizedMatcher(sonarVersion);
    }

    public static BundleSynchronizedMatcher isBundleUpToDate(URI referenceEnglishBundleURI) {
        return new BundleSynchronizedMatcher(referenceEnglishBundleURI);
    }

    public static BundleSynchronizedMatcher isBundleUpToDate() {
        return new BundleSynchronizedMatcher();
    }

    public static void assertAllBundlesUpToDate() {
        try {
            I18nMatchers.assertAllBundlesUpToDate(null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static void assertAllBundlesUpToDate(String sonarVersion, Map<String, String> pluginIdsToBundleUrlMap) throws URISyntaxException {
        File bundleFolder = TestUtils.getResource("/org/sonar/l10n/");
        if (bundleFolder == null || !bundleFolder.isDirectory()) {
            Assert.fail((String)"No bundle found in '/org/sonar/l10n/'");
        }
        Collection bundles = FileUtils.listFiles((File)bundleFolder, (String[])new String[]{"properties"}, (boolean)false);
        HashMap failedAssertionMessages = Maps.newHashMap();
        for (File bundle : bundles) {
            String bundleName = bundle.getName();
            if (bundleName.indexOf(95) <= 0) continue;
            try {
                String baseBundleName = BundleSynchronizedMatcher.extractDefaultBundleName(bundleName);
                String pluginId = StringUtils.substringBefore((String)baseBundleName, (String)".");
                if (BundleSynchronizedMatcher.isCoreBundle(baseBundleName)) {
                    Assert.assertThat((Object)bundleName, (Matcher)I18nMatchers.isBundleUpToDate(sonarVersion));
                    continue;
                }
                if (pluginIdsToBundleUrlMap != null && pluginIdsToBundleUrlMap.get(pluginId) != null) {
                    Assert.assertThat((Object)bundleName, (Matcher)I18nMatchers.isBundleUpToDate(new URI(pluginIdsToBundleUrlMap.get(pluginId))));
                    continue;
                }
                Assert.assertThat((Object)bundleName, (Matcher)I18nMatchers.isBundleUpToDate());
            }
            catch (AssertionError e) {
                failedAssertionMessages.put(bundleName, ((Throwable)((Object)e)).getMessage());
            }
        }
        if (!failedAssertionMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(failedAssertionMessages.size());
            message.append(" bundles are not up-to-date: ");
            message.append(StringUtils.join(failedAssertionMessages.keySet(), (String)", "));
            message.append("\n\n");
            message.append(StringUtils.join(failedAssertionMessages.values(), (String)"\n\n"));
            Assert.fail((String)message.toString());
        }
    }
}

