/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.i18n;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.sonar.test.TestUtils;
import org.sonar.test.i18n.BundleSynchronizedMatcher;

public final class I18nMatchers {
    private I18nMatchers() {
    }

    public static BundleSynchronizedMatcher isBundleUpToDate(String sonarVersion) {
        return new BundleSynchronizedMatcher(sonarVersion);
    }

    public static BundleSynchronizedMatcher isBundleUpToDate() {
        return new BundleSynchronizedMatcher(null);
    }

    public static void assertAllBundlesUpToDate(String sonarVersion) {
        File bundleFolder = TestUtils.getResource("/org/sonar/l10n/");
        if (bundleFolder == null || !bundleFolder.isDirectory()) {
            Assert.fail((String)"No bundle found in '/org/sonar/l10n/'");
        }
        Collection bundles = FileUtils.listFiles((File)bundleFolder, (String[])new String[]{"properties"}, (boolean)false);
        HashMap failedAssertionMessages = Maps.newHashMap();
        for (File bundle : bundles) {
            String bundleName = bundle.getName();
            if (bundleName.indexOf(95) <= 0) continue;
            try {
                Assert.assertThat((Object)bundleName, (Matcher)I18nMatchers.isBundleUpToDate(sonarVersion));
            }
            catch (AssertionError e) {
                failedAssertionMessages.put(bundleName, ((Throwable)((Object)e)).getMessage());
            }
        }
        if (!failedAssertionMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(failedAssertionMessages.size());
            message.append(" bundles are not up-to-date: ");
            message.append(StringUtils.join(failedAssertionMessages.keySet(), (String)", "));
            message.append("\n\n");
            message.append(StringUtils.join(failedAssertionMessages.values(), (String)"\n\n"));
            Assert.fail((String)message.toString());
        }
    }

    public static void assertAllBundlesUpToDate() {
        I18nMatchers.assertAllBundlesUpToDate(null);
    }
}

