/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.sensor.issue.IssueBuilder;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;

public class DefaultIssueBuilder
implements IssueBuilder {
    private static final String INPUT_DIR_SHOULD_BE_NON_NULL = "InputDir should be non null";
    private static final String INPUT_FILE_SHOULD_BE_NON_NULL = "InputFile should be non null";
    private static final String ON_FILE_OR_ON_DIR_ALREADY_CALLED = "onFile or onDir already called";
    private static final String ON_PROJECT_ALREADY_CALLED = "onProject already called";
    String key;
    boolean onProject = false;
    InputPath path;
    RuleKey ruleKey;
    String message;
    Integer line;
    Double effortToFix;
    String severity;

    @Override
    public DefaultIssueBuilder ruleKey(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public DefaultIssueBuilder onFile(InputFile file) {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)ON_PROJECT_ALREADY_CALLED);
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (Object)ON_FILE_OR_ON_DIR_ALREADY_CALLED);
        Preconditions.checkNotNull((Object)file, (Object)INPUT_FILE_SHOULD_BE_NON_NULL);
        this.path = file;
        return this;
    }

    @Override
    public DefaultIssueBuilder onDir(InputDir dir) {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)ON_PROJECT_ALREADY_CALLED);
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (Object)ON_FILE_OR_ON_DIR_ALREADY_CALLED);
        Preconditions.checkNotNull((Object)dir, (Object)INPUT_DIR_SHOULD_BE_NON_NULL);
        this.path = dir;
        return this;
    }

    @Override
    public DefaultIssueBuilder onProject() {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)ON_PROJECT_ALREADY_CALLED);
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (Object)ON_FILE_OR_ON_DIR_ALREADY_CALLED);
        this.onProject = true;
        return this;
    }

    @Override
    public DefaultIssueBuilder atLine(int line) {
        Preconditions.checkState((this.path != null && this.path instanceof InputFile ? 1 : 0) != 0, (Object)"atLine should be called after onFile");
        this.line = line;
        return this;
    }

    @Override
    public DefaultIssueBuilder effortToFix(@Nullable Double effortToFix) {
        this.effortToFix = effortToFix;
        return this;
    }

    @Override
    public DefaultIssueBuilder message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public IssueBuilder severity(@Nullable String severity) {
        Preconditions.checkState((severity == null || Severity.ALL.contains(severity) ? 1 : 0) != 0, (Object)("Invalid severity: " + severity));
        this.severity = severity;
        return this;
    }

    public DefaultIssueBuilder withKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public DefaultIssue build() {
        DefaultIssue result = new DefaultIssue(this);
        this.reset();
        return result;
    }

    private void reset() {
        this.key = null;
        this.onProject = false;
        this.path = null;
        this.ruleKey = null;
        this.message = null;
        this.line = null;
        this.effortToFix = null;
        this.severity = null;
    }
}

