/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueBuilder;
import org.sonar.api.rule.RuleKey;

public class DefaultIssue
implements Issue,
Serializable {
    private final String key;
    private final InputPath inputPath;
    private final RuleKey ruleKey;
    private String message;
    private final Integer line;
    private final Double effortToFix;
    private String severity;

    DefaultIssue(DefaultIssueBuilder builder) {
        Preconditions.checkNotNull((Object)builder.ruleKey, (Object)"ruleKey is mandatory on issue");
        this.inputPath = builder.path;
        this.ruleKey = builder.ruleKey;
        this.message = builder.message;
        this.line = builder.line;
        this.effortToFix = builder.effortToFix;
        this.severity = builder.severity;
        this.key = builder.key == null ? UUID.randomUUID().toString() : builder.key;
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Fail to generate issue key");
    }

    public String key() {
        return this.key;
    }

    @Override
    @Nullable
    public InputPath inputPath() {
        return this.inputPath;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    @CheckForNull
    public String message() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Integer line() {
        return this.line;
    }

    @Override
    @Nullable
    public Double effortToFix() {
        return this.effortToFix;
    }

    @Override
    @CheckForNull
    public String severity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIssue that = (DefaultIssue)o;
        return !this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

