/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.duplication.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.duplication.DuplicationBuilder;
import org.sonar.api.batch.sensor.duplication.DuplicationGroup;

public class DefaultDuplicationBuilder
implements DuplicationBuilder {
    private final InputFile inputFile;
    private DuplicationGroup current = null;
    private List<DuplicationGroup> duplications;

    public DefaultDuplicationBuilder(InputFile inputFile) {
        this.inputFile = inputFile;
        this.duplications = new ArrayList<DuplicationGroup>();
    }

    @Override
    public DuplicationBuilder originBlock(int startLine, int endLine) {
        if (this.current != null) {
            this.duplications.add(this.current);
        }
        this.current = new DuplicationGroup(new DuplicationGroup.Block(((DefaultInputFile)this.inputFile).key(), startLine, endLine - startLine + 1));
        return this;
    }

    @Override
    public DuplicationBuilder isDuplicatedBy(InputFile sameOrOtherFile, int startLine, int endLine) {
        return this.isDuplicatedBy(((DefaultInputFile)sameOrOtherFile).key(), startLine, endLine);
    }

    public DuplicationBuilder isDuplicatedBy(String fileKey, int startLine, int endLine) {
        Preconditions.checkNotNull((Object)this.current, (Object)"Call originBlock() first");
        this.current.addDuplicate(new DuplicationGroup.Block(fileKey, startLine, endLine - startLine + 1));
        return this;
    }

    @Override
    public List<DuplicationGroup> build() {
        Preconditions.checkNotNull((Object)this.current, (Object)"Call originBlock() first");
        this.duplications.add(this.current);
        List<DuplicationGroup> result = this.duplications;
        this.reset();
        return result;
    }

    private void reset() {
        this.duplications = new ArrayList<DuplicationGroup>();
        this.current = null;
    }
}

