/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFilePredicates;
import org.sonar.api.batch.fs.internal.OptimizedFilePredicateAdapter;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.PathUtils;

public class DefaultFileSystem
implements FileSystem {
    private final Cache cache;
    private final SortedSet<String> languages = new TreeSet<String>();
    private File baseDir;
    private File workDir;
    private Charset encoding;
    private final FilePredicates predicates;

    public DefaultFileSystem(File baseDir) {
        this(baseDir, new MapCache());
    }

    protected DefaultFileSystem(File baseDir, Cache cache) {
        this.baseDir = baseDir != null ? baseDir.getAbsoluteFile() : new File(".");
        this.cache = cache;
        this.predicates = new DefaultFilePredicates(baseDir);
    }

    @Override
    public File baseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public DefaultFileSystem setEncoding(@Nullable Charset e) {
        this.encoding = e;
        return this;
    }

    @Override
    public Charset encoding() {
        return this.encoding == null ? Charset.defaultCharset() : this.encoding;
    }

    public boolean isDefaultJvmEncoding() {
        return this.encoding == null;
    }

    public DefaultFileSystem setWorkDir(File d) {
        this.workDir = d.getAbsoluteFile();
        return this;
    }

    @Override
    public File workDir() {
        return this.workDir;
    }

    @Override
    public InputFile inputFile(FilePredicate predicate) {
        Iterable<InputFile> files = this.inputFiles(predicate);
        Iterator<InputFile> iterator = files.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        InputFile first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate predicate) {
        this.doPreloadFiles();
        return OptimizedFilePredicateAdapter.create(predicate).get(this.cache);
    }

    @Override
    public boolean hasFiles(FilePredicate predicate) {
        return this.inputFiles(predicate).iterator().hasNext();
    }

    @Override
    public Iterable<File> files(FilePredicate predicate) {
        this.doPreloadFiles();
        return Iterables.transform(this.inputFiles(predicate), (Function)new Function<InputFile, File>(){

            public File apply(InputFile input) {
                return input.file();
            }
        });
    }

    @Override
    public InputDir inputDir(File dir) {
        this.doPreloadFiles();
        String relativePath = PathUtils.sanitize(new PathResolver().relativePath(this.baseDir, dir));
        if (relativePath == null) {
            return null;
        }
        return this.cache.inputDir(relativePath);
    }

    public DefaultFileSystem add(InputFile inputFile) {
        this.cache.add(inputFile);
        if (inputFile.language() != null) {
            this.languages.add(inputFile.language());
        }
        return this;
    }

    public DefaultFileSystem add(InputDir inputDir) {
        this.cache.add(inputDir);
        return this;
    }

    public DefaultFileSystem addLanguages(String language, String ... others) {
        this.languages.add(language);
        Collections.addAll(this.languages, others);
        return this;
    }

    @Override
    public SortedSet<String> languages() {
        this.doPreloadFiles();
        return this.languages;
    }

    @Override
    public FilePredicates predicates() {
        return this.predicates;
    }

    protected void doPreloadFiles() {
    }

    private static class MapCache
    extends Cache {
        private final Map<String, InputFile> fileMap = new HashMap<String, InputFile>();
        private final Map<String, InputDir> dirMap = new HashMap<String, InputDir>();

        private MapCache() {
        }

        @Override
        public Iterable<InputFile> inputFiles() {
            return new ArrayList<InputFile>(this.fileMap.values());
        }

        @Override
        public InputFile inputFile(String relativePath) {
            return this.fileMap.get(relativePath);
        }

        @Override
        public InputDir inputDir(String relativePath) {
            return this.dirMap.get(relativePath);
        }

        @Override
        protected void doAdd(InputFile inputFile) {
            this.fileMap.put(inputFile.relativePath(), inputFile);
        }

        @Override
        protected void doAdd(InputDir inputDir) {
            this.dirMap.put(inputDir.relativePath(), inputDir);
        }
    }

    public static abstract class Cache
    implements FileSystem.Index {
        @Override
        public abstract Iterable<InputFile> inputFiles();

        @Override
        @CheckForNull
        public abstract InputFile inputFile(String var1);

        @Override
        @CheckForNull
        public abstract InputDir inputDir(String var1);

        protected abstract void doAdd(InputFile var1);

        protected abstract void doAdd(InputDir var1);

        final void add(InputFile inputFile) {
            this.doAdd(inputFile);
        }

        public void add(InputDir inputDir) {
            this.doAdd(inputDir);
        }
    }
}

