/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.database.model.Snapshot;

@Entity
@Table(name="events")
public class Event
extends BaseIdentifiable {
    public static final String CATEGORY_VERSION = "Version";
    public static final String CATEGORY_ALERT = "Alert";
    public static final String CATEGORY_PROFILE = "Profile";
    @Column(name="name", updatable=true, nullable=true, length=400)
    private String name;
    @Column(name="description", updatable=true, nullable=true, length=4000)
    private String description;
    @Column(name="category", updatable=true, nullable=true, length=50)
    private String category;
    @Column(name="event_date", updatable=true, nullable=false)
    private Date date;
    @Column(name="created_at", updatable=true, nullable=true)
    private Date createdAt;
    @Column(name="event_data", updatable=true, nullable=true)
    private String data;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="snapshot_id", updatable=true, nullable=true)
    private Snapshot snapshot;
    @Column(name="resource_id", updatable=true, nullable=true)
    private Integer resourceId;

    public Event() {
    }

    public Event(String name, String description, String category) {
        this.name = name;
        this.description = description;
        this.category = category;
    }

    @Deprecated
    public Event(String name, String description, String category, Date date, Integer resourceId) {
        this.name = name;
        this.description = description;
        this.category = category;
        this.date = date;
        this.resourceId = resourceId;
    }

    @Deprecated
    public Event(String name, String description, String category, Snapshot snapshot) {
        this.name = name;
        this.description = description;
        this.category = category;
        this.setSnapshot(snapshot);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isVersionCategory() {
        return CATEGORY_VERSION.equalsIgnoreCase(this.category);
    }

    public boolean isProfileCategory() {
        return CATEGORY_PROFILE.equalsIgnoreCase(this.category);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public final void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
        if (snapshot != null) {
            this.date = snapshot.getCreatedAt();
            this.resourceId = snapshot.getResourceId();
        }
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public Event setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("categ", (Object)this.category).append("date", (Object)this.date).append("snapshot", (Object)this.snapshot).append("resource", (Object)this.resourceId).toString();
    }
}

