/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.Writer;
import javax.annotation.Nullable;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.sonar.api.utils.text.WriterException;

public class XmlWriter {
    private final XMLStreamWriter stream;

    private XmlWriter(Writer writer) {
        try {
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            this.stream = xmlFactory.createXMLStreamWriter(writer);
        }
        catch (Exception e) {
            throw new WriterException("Fail to initialize XML Stream writer", e);
        }
    }

    public static XmlWriter of(Writer writer) {
        return new XmlWriter(writer);
    }

    public XmlWriter declaration() {
        try {
            this.stream.writeStartDocument();
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    public XmlWriter begin(String nodeName) {
        try {
            this.stream.writeStartElement(nodeName);
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    public XmlWriter end() {
        try {
            this.stream.writeEndElement();
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    public XmlWriter end(String unused) {
        return this.end();
    }

    public XmlWriter prop(String nodeName, @Nullable String value) {
        if (value != null) {
            this.begin(nodeName).value(value).end();
        }
        return this;
    }

    public XmlWriter prop(String nodeName, @Nullable Number value) {
        if (value != null) {
            this.begin(nodeName).value(value).end();
        }
        return this;
    }

    public XmlWriter prop(String nodeName, boolean value) {
        return this.begin(nodeName).value(value).end();
    }

    public XmlWriter prop(String nodeName, long value) {
        return this.begin(nodeName).value(value).end();
    }

    public XmlWriter prop(String nodeName, double value) {
        return this.begin(nodeName).value(value).end();
    }

    private XmlWriter value(boolean value) {
        try {
            this.stream.writeCharacters(String.valueOf(value));
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    private XmlWriter value(double value) {
        try {
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                throw new WriterException("Fail to write XML. Double value is not valid: " + value);
            }
            this.stream.writeCharacters(String.valueOf(value));
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    private XmlWriter value(@Nullable String value) {
        try {
            if (value != null) {
                this.stream.writeCharacters(value);
            }
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    private XmlWriter value(long value) {
        try {
            this.stream.writeCharacters(String.valueOf(value));
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    private XmlWriter value(@Nullable Number value) {
        try {
            if (value != null) {
                this.stream.writeCharacters(String.valueOf(value));
            }
            return this;
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    public void close() {
        try {
            this.stream.writeEndDocument();
            this.stream.flush();
            this.stream.close();
        }
        catch (XMLStreamException e) {
            throw this.rethrow(e);
        }
    }

    private IllegalStateException rethrow(XMLStreamException e) {
        throw new IllegalStateException("Fail to write XML: " + e.getMessage());
    }
}

