/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractFilePredicate;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.PathUtils;

class AbsolutePathPredicate
extends AbstractFilePredicate {
    private final String path;
    private final File baseDir;

    AbsolutePathPredicate(String path, File baseDir) {
        this.baseDir = baseDir;
        this.path = PathUtils.sanitize(path);
    }

    @Override
    public boolean apply(InputFile f) {
        return this.path.equals(f.absolutePath());
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        String relative = PathUtils.sanitize(new PathResolver().relativePath(this.baseDir, new File(this.path)));
        if (relative == null) {
            return Collections.emptyList();
        }
        InputFile f = index.inputFile(relative);
        return f != null ? Arrays.asList(f) : Collections.emptyList();
    }

    @Override
    public int priority() {
        return 20;
    }
}

