/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;

public class UriReader
implements BatchComponent,
ServerComponent {
    private final Map<String, SchemeProcessor> processorsByScheme = Maps.newHashMap();

    public UriReader(SchemeProcessor[] processors) {
        List allProcessors = Lists.asList((Object)new FileProcessor(), (Object[])processors);
        for (SchemeProcessor processor : allProcessors) {
            for (String scheme : processor.getSupportedSchemes()) {
                this.processorsByScheme.put(scheme.toLowerCase(Locale.ENGLISH), processor);
            }
        }
    }

    public byte[] readBytes(URI uri) {
        return this.searchForSupportedProcessor(uri).readBytes(uri);
    }

    public String readString(URI uri, Charset charset) {
        return this.searchForSupportedProcessor(uri).readString(uri, charset);
    }

    public String description(URI uri) {
        SchemeProcessor reader = this.searchForSupportedProcessor(uri);
        return reader.description(uri);
    }

    @VisibleForTesting
    SchemeProcessor searchForSupportedProcessor(URI uri) {
        SchemeProcessor processor = this.processorsByScheme.get(uri.getScheme().toLowerCase(Locale.ENGLISH));
        Preconditions.checkArgument((processor != null ? 1 : 0) != 0, (Object)("URI schema is not supported: " + uri.getScheme()));
        return processor;
    }

    private static class FileProcessor
    extends SchemeProcessor {
        private FileProcessor() {
        }

        @Override
        public String[] getSupportedSchemes() {
            return new String[]{"file"};
        }

        @Override
        byte[] readBytes(URI uri) {
            try {
                return Files.toByteArray((File)new File(uri));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        String readString(URI uri, Charset charset) {
            try {
                return Files.toString((File)new File(uri), (Charset)charset);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        String description(URI uri) {
            return new File(uri).getAbsolutePath();
        }
    }

    static abstract class SchemeProcessor {
        SchemeProcessor() {
        }

        abstract String[] getSupportedSchemes();

        abstract byte[] readBytes(URI var1);

        abstract String readString(URI var1, Charset var2);

        abstract String description(URI var1);
    }
}

