/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public final class License {
    private String product;
    private String organization;
    private String expirationDate;
    private String type;
    private String server;
    private Map<String, String> additionalProperties;

    private License(Map<String, String> properties) {
        this.additionalProperties = Maps.newHashMap(properties);
        this.product = StringUtils.defaultString((String)this.get("Product", properties), (String)this.get("Plugin", properties));
        this.organization = StringUtils.defaultString((String)this.get("Organisation", properties), (String)this.get("Name", properties));
        this.expirationDate = StringUtils.defaultString((String)this.get("Expiration", properties), (String)this.get("Expires", properties));
        this.type = this.get("Type", properties);
        this.server = this.get("Server", properties);
        this.additionalProperties.remove("Digest");
        this.additionalProperties.remove("Obeo");
    }

    private String get(String key, Map<String, String> properties) {
        this.additionalProperties.remove(key);
        return properties.get(key);
    }

    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    @Nullable
    public String getProduct() {
        return this.product;
    }

    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @Nullable
    public String getExpirationDateAsString() {
        return this.expirationDate;
    }

    @Nullable
    public Date getExpirationDate() {
        return org.sonar.api.utils.DateUtils.parseDateQuietly(this.expirationDate);
    }

    public boolean isExpired() {
        return this.isExpired(new Date());
    }

    @VisibleForTesting
    boolean isExpired(Date now) {
        Date date = this.getExpirationDate();
        return date != null && !date.after(DateUtils.truncate((Date)now, (int)5));
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getServer() {
        return this.server;
    }

    public static License readBase64(String base64) {
        return License.readPlainText(new String(Base64.decodeBase64((byte[])base64.getBytes())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static License readPlainText(String data) {
        HashMap props = Maps.newHashMap();
        StringReader reader = new StringReader(data);
        try {
            List lines = IOUtils.readLines((Reader)reader);
            for (String line : lines) {
                if (!StringUtils.isNotBlank((String)line) || line.indexOf(58) <= 0) continue;
                String key = StringUtils.substringBefore((String)line, (String)":");
                String value = StringUtils.substringAfter((String)line, (String)":");
                props.put(StringUtils.trimToEmpty((String)key), StringUtils.trimToEmpty((String)value));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return new License(props);
    }
}

