/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.debt.DebtRemediationFunction;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.RuleParam;
import org.sonar.api.batch.rule.internal.DefaultRuleParam;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.batch.rule.internal.NewRuleParam;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;

@Immutable
public class DefaultRule
implements Rule {
    private final RuleKey key;
    private final Integer id;
    private final String name;
    private final String severity;
    private final String description;
    private final String internalKey;
    private final String debtSubCharacteristic;
    private final RuleStatus status;
    private final DebtRemediationFunction debtRemediationFunction;
    private final Map<String, RuleParam> params;

    DefaultRule(NewRule newRule) {
        this.key = newRule.key;
        this.id = newRule.id;
        this.name = newRule.name;
        this.severity = newRule.severity;
        this.description = newRule.description;
        this.internalKey = newRule.internalKey;
        this.status = newRule.status;
        this.debtSubCharacteristic = newRule.debtSubCharacteristic;
        this.debtRemediationFunction = newRule.debtRemediationFunction;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NewRuleParam newRuleParam : newRule.params.values()) {
            builder.put((Object)newRuleParam.key, (Object)new DefaultRuleParam(newRuleParam));
        }
        this.params = builder.build();
    }

    @Override
    public RuleKey key() {
        return this.key;
    }

    @CheckForNull
    public Integer id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String internalKey() {
        return this.internalKey;
    }

    @Override
    public RuleStatus status() {
        return this.status;
    }

    @Override
    public String debtSubCharacteristic() {
        return this.debtSubCharacteristic;
    }

    @Override
    public DebtRemediationFunction debtRemediationFunction() {
        return this.debtRemediationFunction;
    }

    @Override
    public RuleParam param(String paramKey) {
        return this.params.get(paramKey);
    }

    @Override
    public Collection<RuleParam> params() {
        return this.params.values();
    }
}

