/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

@Immutable
public class DefaultActiveRule
implements ActiveRule {
    private final RuleKey ruleKey;
    private final String name;
    private final String severity;
    private final String internalKey;
    private final String language;
    private final Map<String, String> params;

    DefaultActiveRule(NewActiveRule newActiveRule) {
        this.severity = newActiveRule.severity;
        this.name = newActiveRule.name;
        this.internalKey = newActiveRule.internalKey;
        this.ruleKey = newActiveRule.ruleKey;
        this.params = ImmutableMap.copyOf(newActiveRule.params);
        this.language = newActiveRule.language;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @Override
    public String language() {
        return this.language;
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public String internalKey() {
        return this.internalKey;
    }
}

