/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.api.utils.text.WriterException;

public class CsvWriter {
    private final Writer writer;
    private static final String VALUE_SEPARATOR = ",";
    private static final String LINE_SEPARATOR = "\r\n";

    private CsvWriter(Writer writer) {
        this.writer = writer;
    }

    public static CsvWriter of(Writer writer) {
        return new CsvWriter(writer);
    }

    public CsvWriter values(String ... values) {
        for (int index = 0; index < values.length; ++index) {
            String value;
            if (index > 0) {
                this.write(VALUE_SEPARATOR);
            }
            if ((value = values[index]) != null) {
                this.write(StringEscapeUtils.escapeCsv((String)value));
            }
            if (index != values.length - 1) continue;
            this.write(LINE_SEPARATOR);
        }
        return this;
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new WriterException("Fail to close CSV output", e);
        }
    }

    private void write(String s) {
        try {
            this.writer.append(s);
        }
        catch (IOException e) {
            throw new WriterException("Fail to generate CSV with value: " + s, e);
        }
    }
}

