/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.ServerExtension;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.DefaultDebtRemediationFunctions;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RuleTagFormat;

public interface RulesDefinition
extends ServerExtension {
    public void define(Context var1);

    @Immutable
    public static class Param {
        private final String key;
        private final String name;
        private final String description;
        private final String defaultValue;
        private final RuleParamType type;

        private Param(NewParam newParam) {
            this.key = newParam.key;
            this.name = newParam.name;
            this.description = newParam.description;
            this.defaultValue = newParam.defaultValue;
            this.type = newParam.type;
        }

        public String key() {
            return this.key;
        }

        public String name() {
            return this.name;
        }

        @Nullable
        public String description() {
            return this.description;
        }

        @Nullable
        public String defaultValue() {
            return this.defaultValue;
        }

        public RuleParamType type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param that = (Param)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static class NewParam {
        private final String key;
        private String name;
        private String description;
        private String defaultValue;
        private RuleParamType type = RuleParamType.STRING;

        private NewParam(String key) {
            this.key = this.name = key;
        }

        public String key() {
            return this.key;
        }

        public NewParam setName(@Nullable String s) {
            this.name = StringUtils.defaultIfBlank((String)s, (String)this.key);
            return this;
        }

        public NewParam setType(RuleParamType t) {
            this.type = t;
            return this;
        }

        public NewParam setDescription(@Nullable String s) {
            this.description = StringUtils.defaultIfBlank((String)s, null);
            return this;
        }

        public NewParam setDefaultValue(@Nullable String s) {
            this.defaultValue = s;
            return this;
        }
    }

    @Immutable
    public static class Rule {
        private final Repository repository;
        private final String repoKey;
        private final String key;
        private final String name;
        private final String htmlDescription;
        private final String internalKey;
        private final String severity;
        private final boolean template;
        private final String debtSubCharacteristic;
        private final DebtRemediationFunction debtRemediationFunction;
        private final String effortToFixDescription;
        private final Set<String> tags;
        private final Map<String, Param> params;
        private final RuleStatus status;

        private Rule(Repository repository, NewRule newRule) {
            this.repository = repository;
            this.repoKey = newRule.repoKey;
            this.key = newRule.key;
            this.name = newRule.name;
            this.htmlDescription = newRule.htmlDescription;
            this.internalKey = newRule.internalKey;
            this.severity = newRule.severity;
            this.template = newRule.template;
            this.status = newRule.status;
            this.debtSubCharacteristic = newRule.debtSubCharacteristic;
            this.debtRemediationFunction = newRule.debtRemediationFunction;
            this.effortToFixDescription = newRule.effortToFixDescription;
            this.tags = ImmutableSortedSet.copyOf((Collection)newRule.tags);
            ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
            for (NewParam newParam : newRule.paramsByKey.values()) {
                paramsBuilder.put((Object)newParam.key, (Object)new Param(newParam));
            }
            this.params = paramsBuilder.build();
        }

        public Repository repository() {
            return this.repository;
        }

        public String key() {
            return this.key;
        }

        public String name() {
            return this.name;
        }

        public String severity() {
            return this.severity;
        }

        @CheckForNull
        public String htmlDescription() {
            return this.htmlDescription;
        }

        public boolean template() {
            return this.template;
        }

        public RuleStatus status() {
            return this.status;
        }

        @CheckForNull
        public String debtSubCharacteristic() {
            return this.debtSubCharacteristic;
        }

        @CheckForNull
        public DebtRemediationFunction debtRemediationFunction() {
            return this.debtRemediationFunction;
        }

        @CheckForNull
        public String effortToFixDescription() {
            return this.effortToFixDescription;
        }

        @CheckForNull
        public Param param(String key) {
            return this.params.get(key);
        }

        public List<Param> params() {
            return ImmutableList.copyOf(this.params.values());
        }

        public Set<String> tags() {
            return this.tags;
        }

        @CheckForNull
        public String internalKey() {
            return this.internalKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule other = (Rule)o;
            return this.key.equals(other.key) && this.repoKey.equals(other.repoKey);
        }

        public int hashCode() {
            int result = this.repoKey.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        public String toString() {
            return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
        }
    }

    public static class NewRule {
        private final String repoKey;
        private final String key;
        private String name;
        private String htmlDescription;
        private String internalKey;
        private String severity = "MAJOR";
        private boolean template;
        private RuleStatus status = RuleStatus.defaultStatus();
        private String debtSubCharacteristic;
        private DebtRemediationFunction debtRemediationFunction;
        private String effortToFixDescription;
        private final Set<String> tags = Sets.newTreeSet();
        private final Map<String, NewParam> paramsByKey = Maps.newHashMap();
        private final DebtRemediationFunctions functions;

        private NewRule(String repoKey, String key) {
            this.repoKey = repoKey;
            this.key = key;
            this.functions = new DefaultDebtRemediationFunctions(repoKey, key);
        }

        public String key() {
            return this.key;
        }

        public NewRule setName(@Nullable String s) {
            this.name = StringUtils.trimToNull((String)s);
            return this;
        }

        public NewRule setTemplate(boolean template) {
            this.template = template;
            return this;
        }

        public NewRule setSeverity(String s) {
            if (!Severity.ALL.contains(s)) {
                throw new IllegalArgumentException(String.format("Severity of rule %s is not correct: %s", this, s));
            }
            this.severity = s;
            return this;
        }

        public NewRule setHtmlDescription(@Nullable String s) {
            this.htmlDescription = StringUtils.trimToNull((String)s);
            return this;
        }

        public NewRule setHtmlDescription(@Nullable URL classpathUrl) {
            if (classpathUrl != null) {
                try {
                    this.setHtmlDescription(IOUtils.toString((URL)classpathUrl));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to read: " + classpathUrl, e);
                }
            } else {
                this.htmlDescription = null;
            }
            return this;
        }

        public NewRule setStatus(RuleStatus status) {
            if (status.equals((Object)RuleStatus.REMOVED)) {
                throw new IllegalArgumentException(String.format("Status 'REMOVED' is not accepted on rule '%s'", this));
            }
            this.status = status;
            return this;
        }

        public NewRule setDebtSubCharacteristic(@Nullable String s) {
            this.debtSubCharacteristic = s;
            return this;
        }

        public DebtRemediationFunctions debtRemediationFunctions() {
            return this.functions;
        }

        public NewRule setDebtRemediationFunction(@Nullable DebtRemediationFunction fn) {
            this.debtRemediationFunction = fn;
            return this;
        }

        public NewRule setEffortToFixDescription(@Nullable String s) {
            this.effortToFixDescription = s;
            return this;
        }

        public NewParam createParam(String paramKey) {
            if (this.paramsByKey.containsKey(paramKey)) {
                throw new IllegalArgumentException(String.format("The parameter '%s' is declared several times on the rule %s", paramKey, this));
            }
            NewParam param = new NewParam(paramKey);
            this.paramsByKey.put(paramKey, param);
            return param;
        }

        @CheckForNull
        public NewParam param(String paramKey) {
            return this.paramsByKey.get(paramKey);
        }

        public Collection<NewParam> params() {
            return this.paramsByKey.values();
        }

        public NewRule addTags(String ... list) {
            for (String tag : list) {
                RuleTagFormat.validate(tag);
                this.tags.add(tag);
            }
            return this;
        }

        public NewRule setTags(String ... list) {
            this.tags.clear();
            this.addTags(list);
            return this;
        }

        public NewRule setInternalKey(@Nullable String s) {
            this.internalKey = s;
            return this;
        }

        private void validate() {
            if (Strings.isNullOrEmpty((String)this.name)) {
                throw new IllegalStateException(String.format("Name of rule %s is empty", this));
            }
            if (Strings.isNullOrEmpty((String)this.htmlDescription)) {
                throw new IllegalStateException(String.format("HTML description of rule %s is empty", this));
            }
            if (Strings.isNullOrEmpty((String)this.debtSubCharacteristic) && this.debtRemediationFunction != null || !Strings.isNullOrEmpty((String)this.debtSubCharacteristic) && this.debtRemediationFunction == null) {
                throw new IllegalStateException(String.format("Both debt sub-characteristic and debt remediation function should be defined on rule '%s'", this));
            }
        }

        public String toString() {
            return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
        }
    }

    public static interface DebtRemediationFunctions {
        public DebtRemediationFunction linear(String var1);

        public DebtRemediationFunction linearWithOffset(String var1, String var2);

        public DebtRemediationFunction constantPerIssue(String var1);
    }

    @Immutable
    public static class RepositoryImpl
    implements Repository {
        private final String key;
        private final String language;
        private final String name;
        private final Map<String, Rule> rulesByKey;

        private RepositoryImpl(NewRepositoryImpl newRepository) {
            this.key = newRepository.key;
            this.language = newRepository.language;
            this.name = newRepository.name;
            ImmutableMap.Builder ruleBuilder = ImmutableMap.builder();
            for (NewRule newRule : newRepository.newRules.values()) {
                newRule.validate();
                ruleBuilder.put((Object)newRule.key, (Object)new Rule(this, newRule));
            }
            this.rulesByKey = ruleBuilder.build();
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        @CheckForNull
        public Rule rule(String ruleKey) {
            return this.rulesByKey.get(ruleKey);
        }

        @Override
        public List<Rule> rules() {
            return ImmutableList.copyOf(this.rulesByKey.values());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepositoryImpl that = (RepositoryImpl)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static interface Repository
    extends ExtendedRepository {
        public String name();
    }

    public static interface ExtendedRepository {
        public String key();

        public String language();

        @CheckForNull
        public Rule rule(String var1);

        public List<Rule> rules();
    }

    public static class NewRepositoryImpl
    implements NewRepository {
        private final Context context;
        private final boolean extended;
        private final String key;
        private String language;
        private String name;
        private final Map<String, NewRule> newRules = Maps.newHashMap();

        private NewRepositoryImpl(Context context, String key, String language, boolean extended) {
            this.extended = extended;
            this.context = context;
            this.key = this.name = key;
            this.language = language;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public NewRepositoryImpl setName(@Nullable String s) {
            if (StringUtils.isNotEmpty((String)s)) {
                this.name = s;
            }
            return this;
        }

        @Override
        public NewRule createRule(String ruleKey) {
            if (this.newRules.containsKey(ruleKey)) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("The rule '%s' of repository '%s' is declared several times", ruleKey, this.key));
            }
            NewRule newRule = new NewRule(this.key, ruleKey);
            this.newRules.put(ruleKey, newRule);
            return newRule;
        }

        @Override
        @CheckForNull
        public NewRule rule(String ruleKey) {
            return this.newRules.get(ruleKey);
        }

        @Override
        public Collection<NewRule> rules() {
            return this.newRules.values();
        }

        @Override
        public void done() {
            if (this.extended) {
                this.context.registerExtendedRepository(this);
            } else {
                this.context.registerRepository(this);
            }
        }
    }

    public static interface NewRepository
    extends NewExtendedRepository {
        public NewRepository setName(String var1);
    }

    public static interface NewExtendedRepository {
        public NewRule createRule(String var1);

        @CheckForNull
        public NewRule rule(String var1);

        public Collection<NewRule> rules();

        public String key();

        public void done();
    }

    public static class Context {
        private final Map<String, Repository> repositoriesByKey = Maps.newHashMap();
        private final ListMultimap<String, ExtendedRepository> extendedRepositoriesByKey = ArrayListMultimap.create();

        public NewRepository createRepository(String key, String language) {
            return new NewRepositoryImpl(this, key, language, false);
        }

        public NewExtendedRepository extendRepository(String key, String language) {
            return new NewRepositoryImpl(this, key, language, true);
        }

        @CheckForNull
        public Repository repository(String key) {
            return this.repositoriesByKey.get(key);
        }

        public List<Repository> repositories() {
            return ImmutableList.copyOf(this.repositoriesByKey.values());
        }

        public List<ExtendedRepository> extendedRepositories(String repositoryKey) {
            return ImmutableList.copyOf((Collection)this.extendedRepositoriesByKey.get((Object)repositoryKey));
        }

        public List<ExtendedRepository> extendedRepositories() {
            return ImmutableList.copyOf((Collection)this.extendedRepositoriesByKey.values());
        }

        private void registerRepository(NewRepositoryImpl newRepository) {
            if (this.repositoriesByKey.containsKey(newRepository.key)) {
                throw new IllegalStateException(String.format("The rule repository '%s' is defined several times", newRepository.key));
            }
            this.repositoriesByKey.put(newRepository.key, new RepositoryImpl(newRepository));
        }

        private void registerExtendedRepository(NewRepositoryImpl newRepository) {
            this.extendedRepositoriesByKey.put((Object)newRepository.key, (Object)new RepositoryImpl(newRepository));
        }
    }

    public static final class SubCharacteristics {
        public static final String MODULARITY = "MODULARITY";
        public static final String TRANSPORTABILITY = "TRANSPORTABILITY";
        public static final String COMPILER_RELATED_PORTABILITY = "COMPILER_RELATED_PORTABILITY";
        public static final String HARDWARE_RELATED_PORTABILITY = "HARDWARE_RELATED_PORTABILITY";
        public static final String LANGUAGE_RELATED_PORTABILITY = "LANGUAGE_RELATED_PORTABILITY";
        public static final String OS_RELATED_PORTABILITY = "OS_RELATED_PORTABILITY";
        public static final String SOFTWARE_RELATED_PORTABILITY = "SOFTWARE_RELATED_PORTABILITY";
        public static final String TIME_ZONE_RELATED_PORTABILITY = "TIME_ZONE_RELATED_PORTABILITY";
        public static final String READABILITY = "READABILITY";
        public static final String UNDERSTANDABILITY = "UNDERSTANDABILITY";
        public static final String API_ABUSE = "API_ABUSE";
        public static final String ERRORS = "ERRORS";
        public static final String INPUT_VALIDATION_AND_REPRESENTATION = "INPUT_VALIDATION_AND_REPRESENTATION";
        public static final String SECURITY_FEATURES = "SECURITY_FEATURES";
        public static final String CPU_EFFICIENCY = "CPU_EFFICIENCY";
        public static final String MEMORY_EFFICIENCY = "MEMORY_EFFICIENCY";
        public static final String NETWORK_USE = "NETWORK_USE";
        public static final String ARCHITECTURE_CHANGEABILITY = "ARCHITECTURE_CHANGEABILITY";
        public static final String DATA_CHANGEABILITY = "DATA_CHANGEABILITY";
        public static final String LOGIC_CHANGEABILITY = "LOGIC_CHANGEABILITY";
        public static final String ARCHITECTURE_RELIABILITY = "ARCHITECTURE_RELIABILITY";
        public static final String DATA_RELIABILITY = "DATA_RELIABILITY";
        public static final String EXCEPTION_HANDLING = "EXCEPTION_HANDLING";
        public static final String FAULT_TOLERANCE = "FAULT_TOLERANCE";
        public static final String INSTRUCTION_RELIABILITY = "INSTRUCTION_RELIABILITY";
        public static final String LOGIC_RELIABILITY = "LOGIC_RELIABILITY";
        public static final String RESOURCE_RELIABILITY = "RESOURCE_RELIABILITY";
        public static final String SYNCHRONIZATION_RELIABILITY = "SYNCHRONIZATION_RELIABILITY";
        public static final String UNIT_TESTS = "UNIT_TESTS";
        public static final String INTEGRATION_TESTABILITY = "INTEGRATION_TESTABILITY";
        public static final String UNIT_TESTABILITY = "UNIT_TESTABILITY";

        private SubCharacteristics() {
        }
    }
}

