/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.WildcardPattern;

public class File
extends Resource {
    public static final String SCOPE = "FIL";
    private String directoryDeprecatedKey;
    private String filename;
    private Language language;
    private Directory parent;
    private String qualifier = "FIL";

    private File() {
    }

    @Deprecated
    public File(String relativePathFromSourceDir) {
        if (relativePathFromSourceDir == null) {
            throw new IllegalArgumentException("File key is null");
        }
        String realKey = File.parseKey(relativePathFromSourceDir);
        if (realKey.indexOf("/") >= 0) {
            this.directoryDeprecatedKey = Directory.parseKey(StringUtils.substringBeforeLast((String)relativePathFromSourceDir, (String)"/"));
            this.filename = StringUtils.substringAfterLast((String)realKey, (String)"/");
            realKey = this.directoryDeprecatedKey + "/" + this.filename;
        } else {
            this.filename = relativePathFromSourceDir;
        }
        this.setDeprecatedKey(realKey);
    }

    @Deprecated
    public File(String relativeDirectoryPathFromSourceDir, String filename) {
        this.filename = StringUtils.trim((String)filename);
        if (StringUtils.isBlank((String)relativeDirectoryPathFromSourceDir)) {
            this.setDeprecatedKey(filename);
        } else {
            this.directoryDeprecatedKey = Directory.parseKey(relativeDirectoryPathFromSourceDir);
            this.setDeprecatedKey(this.directoryDeprecatedKey + "/" + this.filename);
        }
    }

    @Deprecated
    public File(Language language, String relativePathFromSourceDir) {
        this(relativePathFromSourceDir);
        this.language = language;
    }

    @Deprecated
    public File(Language language, String relativeDirectoryPathFromSourceDir, String filename) {
        this(relativeDirectoryPathFromSourceDir, filename);
        this.language = language;
    }

    @Override
    public Directory getParent() {
        if (this.parent == null) {
            this.parent = new Directory(this.directoryDeprecatedKey);
        }
        return this.parent;
    }

    private static String parseKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String normalizedKey = key;
        normalizedKey = normalizedKey.replace('\\', '/');
        normalizedKey = StringUtils.trim((String)normalizedKey);
        return normalizedKey;
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        WildcardPattern matcher = WildcardPattern.create(antPattern, "/");
        return matcher.match(this.getKey());
    }

    @Deprecated
    @CheckForNull
    public static File fromIOFile(java.io.File file, List<java.io.File> sourceDirs) {
        PathResolver.RelativePath relativePath = new PathResolver().relativePath(sourceDirs, file);
        if (relativePath != null) {
            return new File(relativePath.path());
        }
        return null;
    }

    @CheckForNull
    public static File fromIOFile(java.io.File file, Project module) {
        String relativePathFromBasedir = new PathResolver().relativePath(module.getFileSystem().getBasedir(), file);
        if (relativePathFromBasedir != null) {
            return File.create(relativePathFromBasedir);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public String getLongName() {
        return StringUtils.defaultIfBlank((String)this.getPath(), (String)this.getKey());
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @Override
    public final String getScope() {
        return SCOPE;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public static File create(String relativePathFromBasedir) {
        File file = new File();
        String normalizedPath = File.normalize(relativePathFromBasedir);
        file.setKey(normalizedPath);
        file.setPath(normalizedPath);
        String directoryPath = normalizedPath != null && normalizedPath.contains("/") ? StringUtils.substringBeforeLast((String)normalizedPath, (String)"/") : "/";
        file.parent = Directory.create(directoryPath);
        return file;
    }

    public static File create(String relativePathFromBasedir, String relativePathFromSourceDir, Language language, boolean unitTest) {
        File file = File.create(relativePathFromBasedir);
        file.setLanguage(language);
        if (relativePathFromSourceDir.contains("/")) {
            file.filename = StringUtils.substringAfterLast((String)relativePathFromSourceDir, (String)"/");
            file.directoryDeprecatedKey = Directory.parseKey(StringUtils.substringBeforeLast((String)relativePathFromSourceDir, (String)"/"));
            file.setDeprecatedKey(file.directoryDeprecatedKey + "/" + file.filename);
        } else {
            file.filename = relativePathFromSourceDir;
            file.directoryDeprecatedKey = "[root]";
            file.setDeprecatedKey(file.filename);
        }
        if (unitTest) {
            file.setQualifier("UTS");
        }
        file.parent.setDeprecatedKey(file.directoryDeprecatedKey);
        return file;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("deprecatedKey", (Object)this.getDeprecatedKey()).append("path", (Object)this.getPath()).append("dir", (Object)this.directoryDeprecatedKey).append("filename", (Object)this.filename).append("language", (Object)this.language).toString();
    }
}

