/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.platform;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.lifecycle.ReflectionLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.platform.ComponentKeys;
import org.sonar.api.platform.PicoUtils;
import org.sonar.api.platform.PluginMetadata;

public class ComponentContainer
implements BatchComponent,
ServerComponent {
    ComponentContainer parent;
    ComponentContainer child;
    MutablePicoContainer pico;
    PropertyDefinitions propertyDefinitions;
    ComponentKeys componentKeys;

    public ComponentContainer() {
        this.parent = null;
        this.child = null;
        this.pico = ComponentContainer.createPicoContainer();
        this.componentKeys = new ComponentKeys();
        this.propertyDefinitions = new PropertyDefinitions(new Object[0]);
        this.addSingleton(this.propertyDefinitions);
        this.addSingleton(this);
    }

    protected ComponentContainer(ComponentContainer parent) {
        this.parent = parent;
        this.pico = parent.pico.makeChildContainer();
        this.parent.child = this;
        this.propertyDefinitions = parent.propertyDefinitions;
        this.componentKeys = new ComponentKeys();
        this.addSingleton(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        boolean threw = true;
        try {
            this.startComponents();
            threw = false;
        }
        finally {
            this.stopComponents(threw);
        }
    }

    public ComponentContainer startComponents() {
        try {
            this.doBeforeStart();
            this.pico.start();
            this.doAfterStart();
            return this;
        }
        catch (Exception e) {
            throw PicoUtils.propagate(e);
        }
    }

    protected void doBeforeStart() {
    }

    protected void doAfterStart() {
    }

    public ComponentContainer stopComponents() {
        return this.stopComponents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentContainer stopComponents(boolean swallowException) {
        try {
            this.pico.stop();
        }
        catch (RuntimeException e) {
            if (!swallowException) {
                throw PicoUtils.propagate(e);
            }
        }
        finally {
            this.removeChild();
            if (this.parent != null) {
                this.parent.removeChild();
            }
        }
        return this;
    }

    public ComponentContainer add(Object ... objects) {
        for (Object object : objects) {
            if (object instanceof ComponentAdapter) {
                this.addPicoAdapter((ComponentAdapter)object);
                continue;
            }
            if (object instanceof Iterable) {
                this.add(Iterables.toArray((Iterable)((Iterable)object), Object.class));
                continue;
            }
            this.addSingleton(object);
        }
        return this;
    }

    public ComponentContainer addSingletons(Collection components) {
        for (Object component : components) {
            this.addSingleton(component);
        }
        return this;
    }

    public ComponentContainer addSingleton(Object component) {
        return this.addComponent(component, true);
    }

    public ComponentContainer addComponent(Object component, boolean singleton) {
        Object key = this.componentKeys.of(component);
        if (component instanceof ComponentAdapter) {
            this.pico.addAdapter((ComponentAdapter)component);
        } else {
            this.pico.as(new Properties[]{singleton ? Characteristics.CACHE : Characteristics.NO_CACHE}).addComponent(key, component, new Parameter[0]);
            this.declareExtension(null, component);
        }
        return this;
    }

    public ComponentContainer addExtension(@Nullable PluginMetadata plugin, Object extension) {
        Object key = this.componentKeys.of(extension);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(key, extension, new Parameter[0]);
        this.declareExtension(plugin, extension);
        return this;
    }

    public void declareExtension(@Nullable PluginMetadata plugin, Object extension) {
        this.propertyDefinitions.addComponent(extension, plugin != null ? plugin.getName() : "");
    }

    public ComponentContainer addPicoAdapter(ComponentAdapter adapter) {
        this.pico.addAdapter(adapter);
        return this;
    }

    public <T> T getComponentByType(Class<T> tClass) {
        return (T)this.pico.getComponent(tClass);
    }

    public Object getComponentByKey(Object key) {
        return this.pico.getComponent(key);
    }

    public <T> List<T> getComponentsByType(Class<T> tClass) {
        return this.pico.getComponents(tClass);
    }

    public ComponentContainer removeChild() {
        if (this.child != null) {
            this.pico.removeChildContainer((PicoContainer)this.child.pico);
            this.child = null;
        }
        return this;
    }

    public ComponentContainer createChild() {
        return new ComponentContainer(this);
    }

    static MutablePicoContainer createPicoContainer() {
        ReflectionLifecycleStrategy lifecycleStrategy = new ReflectionLifecycleStrategy((ComponentMonitor)new NullComponentMonitor(), "start", "stop", "dispose");
        return new DefaultPicoContainer((ComponentFactory)new OptInCaching(), (LifecycleStrategy)lifecycleStrategy, null);
    }

    public ComponentContainer getParent() {
        return this.parent;
    }

    public ComponentContainer getChild() {
        return this.child;
    }

    public MutablePicoContainer getPicoContainer() {
        return this.pico;
    }
}

