/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import org.apache.commons.io.FilenameUtils;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.UniqueIndexPredicate;

class RelativePathPredicate
implements FilePredicate,
UniqueIndexPredicate {
    private final String path;

    RelativePathPredicate(String path) {
        this.path = FilenameUtils.normalize((String)path, (boolean)true);
    }

    @Override
    public boolean apply(InputFile f) {
        return this.path.equals(f.relativePath());
    }

    @Override
    public Object value() {
        return this.path;
    }

    @Override
    public String indexId() {
        return "rel";
    }
}

