/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FilenameUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;

public class DefaultInputFile
implements InputFile,
org.sonar.api.resources.InputFile,
Serializable {
    private final String relativePath;
    private String absolutePath;
    private String language;
    private InputFile.Type type = InputFile.Type.MAIN;
    private InputFile.Status status;
    private String hash;
    private int lines;
    private String key;
    private String deprecatedKey;
    private String sourceDirAbsolutePath;
    private String pathRelativeToSourceDir;
    private String basedir;

    public DefaultInputFile(String relativePath) {
        this.relativePath = FilenameUtils.normalize((String)relativePath, (boolean)true);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    @CheckForNull
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public File file() {
        if (this.absolutePath == null) {
            throw new IllegalStateException("Can not return the java.io.File because absolute path is not set (see method setFile(java.io.File))");
        }
        return new File(this.absolutePath);
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    @CheckForNull
    public InputFile.Status status() {
        return this.status;
    }

    @CheckForNull
    public String hash() {
        return this.hash;
    }

    @Override
    public int lines() {
        return this.lines;
    }

    @CheckForNull
    public String key() {
        return this.key;
    }

    public DefaultInputFile setAbsolutePath(String s) {
        this.absolutePath = FilenameUtils.normalize((String)s, (boolean)true);
        return this;
    }

    public DefaultInputFile setLanguage(String language) {
        this.language = language;
        return this;
    }

    public DefaultInputFile setFile(File file) {
        this.setAbsolutePath(file.getAbsolutePath());
        return this;
    }

    public DefaultInputFile setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public DefaultInputFile setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public DefaultInputFile setKey(String s) {
        this.key = s;
        return this;
    }

    public String deprecatedKey() {
        return this.deprecatedKey;
    }

    public DefaultInputFile setDeprecatedKey(String s) {
        this.deprecatedKey = s;
        return this;
    }

    public String sourceDirAbsolutePath() {
        return this.sourceDirAbsolutePath;
    }

    public DefaultInputFile setSourceDirAbsolutePath(String s) {
        this.sourceDirAbsolutePath = FilenameUtils.normalize((String)s, (boolean)true);
        return this;
    }

    public String pathRelativeToSourceDir() {
        return this.pathRelativeToSourceDir;
    }

    public DefaultInputFile setPathRelativeToSourceDir(String s) {
        this.pathRelativeToSourceDir = FilenameUtils.normalize((String)s, (boolean)true);
        return this;
    }

    @Override
    @Deprecated
    public File getFileBaseDir() {
        return new File(this.basedir);
    }

    public void setBasedir(File basedir) {
        this.basedir = PathUtils.sanitize(basedir.getAbsolutePath());
    }

    @Override
    @Deprecated
    public File getFile() {
        return this.file();
    }

    @Override
    @Deprecated
    public String getRelativePath() {
        return this.pathRelativeToSourceDir;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.file()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)o;
        return this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return this.relativePath.hashCode();
    }

    public String toString() {
        return "[relative=" + this.relativePath + ", abs=" + this.absolutePath + "]";
    }
}

