/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbsolutePathPredicate;
import org.sonar.api.batch.fs.internal.AndPredicate;
import org.sonar.api.batch.fs.internal.FalsePredicate;
import org.sonar.api.batch.fs.internal.LanguagePredicate;
import org.sonar.api.batch.fs.internal.NotPredicate;
import org.sonar.api.batch.fs.internal.OrPredicate;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.batch.fs.internal.PathPatternPredicate;
import org.sonar.api.batch.fs.internal.RelativePathPredicate;
import org.sonar.api.batch.fs.internal.StatusPredicate;
import org.sonar.api.batch.fs.internal.TruePredicate;
import org.sonar.api.batch.fs.internal.TypePredicate;

public class DefaultFilePredicates
implements FilePredicates {
    DefaultFilePredicates() {
    }

    @Override
    public FilePredicate all() {
        return TruePredicate.TRUE;
    }

    @Override
    public FilePredicate none() {
        return FalsePredicate.FALSE;
    }

    @Override
    public FilePredicate hasAbsolutePath(String s) {
        return new AbsolutePathPredicate(s);
    }

    @Override
    public FilePredicate hasRelativePath(String s) {
        return new RelativePathPredicate(s);
    }

    @Override
    public FilePredicate matchesPathPattern(String inclusionPattern) {
        return new PathPatternPredicate(PathPattern.create(inclusionPattern));
    }

    @Override
    public FilePredicate matchesPathPatterns(String[] inclusionPatterns) {
        if (inclusionPatterns.length == 0) {
            return TruePredicate.TRUE;
        }
        FilePredicate[] predicates = new FilePredicate[inclusionPatterns.length];
        for (int i = 0; i < inclusionPatterns.length; ++i) {
            predicates[i] = new PathPatternPredicate(PathPattern.create(inclusionPatterns[i]));
        }
        return this.or(predicates);
    }

    @Override
    public FilePredicate doesNotMatchPathPattern(String exclusionPattern) {
        return this.not(this.matchesPathPattern(exclusionPattern));
    }

    @Override
    public FilePredicate doesNotMatchPathPatterns(String[] exclusionPatterns) {
        if (exclusionPatterns.length == 0) {
            return TruePredicate.TRUE;
        }
        return this.not(this.matchesPathPatterns(exclusionPatterns));
    }

    @Override
    public FilePredicate hasPath(String s) {
        File file = new File(s);
        if (file.isAbsolute()) {
            return this.hasAbsolutePath(s);
        }
        return this.hasRelativePath(s);
    }

    @Override
    public FilePredicate is(File ioFile) {
        if (ioFile.isAbsolute()) {
            return this.hasAbsolutePath(ioFile.getAbsolutePath());
        }
        return this.hasRelativePath(ioFile.getPath());
    }

    @Override
    public FilePredicate hasLanguage(String language) {
        return new LanguagePredicate(language);
    }

    @Override
    public FilePredicate hasLanguages(Collection<String> languages) {
        ArrayList list = Lists.newArrayList();
        for (String language : languages) {
            list.add(this.hasLanguage(language));
        }
        return this.or(list);
    }

    @Override
    public FilePredicate hasStatus(InputFile.Status status) {
        return new StatusPredicate(status);
    }

    @Override
    public FilePredicate hasType(InputFile.Type type) {
        return new TypePredicate(type);
    }

    @Override
    public FilePredicate not(FilePredicate p) {
        return new NotPredicate(p);
    }

    @Override
    public FilePredicate or(Collection<FilePredicate> or) {
        return new OrPredicate(or);
    }

    @Override
    public FilePredicate or(FilePredicate ... or) {
        return new OrPredicate(Arrays.asList(or));
    }

    @Override
    public FilePredicate or(FilePredicate first, FilePredicate second) {
        return new OrPredicate(Arrays.asList(first, second));
    }

    @Override
    public FilePredicate and(Collection<FilePredicate> and) {
        return new AndPredicate(and);
    }

    @Override
    public FilePredicate and(FilePredicate ... and) {
        return new AndPredicate(Arrays.asList(and));
    }

    @Override
    public FilePredicate and(FilePredicate first, FilePredicate second) {
        return new AndPredicate(Arrays.asList(first, second));
    }
}

