/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.workflow.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.workflow.Comment;
import org.sonar.api.workflow.MutableReview;
import org.sonar.api.workflow.internal.DefaultComment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class DefaultReview
implements MutableReview {
    private Long violationId;
    private Long reviewId;
    private String ruleRepositoryKey;
    private String ruleKey;
    private String ruleName;
    private Long line;
    private boolean switchedOff = false;
    private boolean manual = false;
    private String message;
    private String status;
    private String resolution;
    private String severity;
    private Map<String, String> properties;
    private List<Comment> newComments;

    public Long getViolationId() {
        return this.violationId;
    }

    public DefaultReview setViolationId(Long violationId) {
        this.violationId = violationId;
        return this;
    }

    @Override
    public Long getReviewId() {
        return this.reviewId;
    }

    public DefaultReview setReviewId(Long reviewId) {
        this.reviewId = reviewId;
        return this;
    }

    @Override
    public String getRuleRepositoryKey() {
        return this.ruleRepositoryKey;
    }

    public DefaultReview setRuleRepositoryKey(String s) {
        this.ruleRepositoryKey = s;
        return this;
    }

    @Override
    public String getRuleKey() {
        return this.ruleKey;
    }

    public DefaultReview setRuleKey(String s) {
        this.ruleKey = s;
        return this;
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }

    public DefaultReview setRuleName(String s) {
        this.ruleName = s;
        return this;
    }

    @Override
    public Long getLine() {
        return this.line;
    }

    public DefaultReview setLine(Long line) {
        this.line = line;
        return this;
    }

    @Override
    public boolean isSwitchedOff() {
        return this.switchedOff;
    }

    public DefaultReview setSwitchedOff(boolean b) {
        this.switchedOff = b;
        return this;
    }

    @Override
    public boolean isManual() {
        return this.manual;
    }

    public DefaultReview setManual(boolean manual) {
        this.manual = manual;
        return this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public DefaultReview setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public DefaultReview setStatus(String s) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)s) ? 1 : 0) != 0);
        this.status = s;
        return this;
    }

    @Override
    public String getResolution() {
        return this.resolution;
    }

    @Override
    public DefaultReview setResolution(@Nullable String s) {
        this.resolution = s;
        return this;
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    public DefaultReview setSeverity(String s) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)s) ? 1 : 0) != 0);
        this.severity = s;
        return this;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public DefaultReview setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public DefaultReview setPropertiesAsString(@Nullable String s) {
        this.properties = s == null ? null : KeyValueFormat.parse(s);
        return this;
    }

    @Override
    public Comment createComment() {
        if (this.newComments == null) {
            this.newComments = Lists.newArrayList();
        }
        DefaultComment comment = new DefaultComment();
        this.newComments.add(comment);
        return comment;
    }

    @Override
    public List<Comment> getNewComments() {
        if (this.newComments == null) {
            return Collections.emptyList();
        }
        return this.newComments;
    }

    @Override
    public DefaultReview setProperty(String key, @Nullable String value) {
        if (this.properties == null) {
            this.properties = Maps.newLinkedHashMap();
        }
        this.properties.put(key, value);
        return this;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).toString();
    }
}

