/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.SonarException;

@Deprecated
public class ServerHttpClient
implements BatchComponent {
    protected static final String SERVER_API_PATH = "/api/server";
    private static final String KEY_PATH = "/api/server/key";
    private static final String VERSION_PATH = "/api/server/version";
    protected static final String MAVEN_PATH = "/deploy/maven";
    private static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    private static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private String url;
    private Integer connectTimeoutMiliseconds = 30000;
    private Integer readTimeoutMiliseconds = 60000;

    public ServerHttpClient(String remoteServerUrl) {
        this(remoteServerUrl, null, null);
    }

    public ServerHttpClient(String remoteServerUrl, Integer connectTimeoutMiliseconds, Integer readTimeoutMiliseconds) {
        this.url = StringUtils.chomp((String)remoteServerUrl, (String)"/");
        if (connectTimeoutMiliseconds != null) {
            this.connectTimeoutMiliseconds = connectTimeoutMiliseconds;
        }
        if (readTimeoutMiliseconds != null) {
            this.readTimeoutMiliseconds = readTimeoutMiliseconds;
        }
    }

    public ServerHttpClient(Configuration configuration) {
        this(configuration.getString("sonar.host.url", "http://localhost:9000"), configuration.getInteger("sonar.host.connectTimeoutMs", Integer.valueOf(30000)), configuration.getInteger("sonar.host.readTimeoutMs", Integer.valueOf(60000)));
    }

    public void checkUp() {
        String exceptionLabel = "Sonar server at " + this.url + " is unreacheable. Either start it or setup the sonar.host.url setting if the URL is incorrect";
        if (this.getId() == null) {
            throw new ServerConnectionException(exceptionLabel);
        }
    }

    public String getId() {
        return this.executeAction(KEY_PATH);
    }

    public String getVersion() {
        return this.executeAction(VERSION_PATH);
    }

    public String getMavenRepositoryUrl() {
        return this.url + MAVEN_PATH;
    }

    protected String executeAction(String action) {
        String result = this.getRemoteContent(this.url + action);
        if (StringUtils.isBlank((String)result)) {
            throw new ServerApiEmptyContentException("Empty " + action + " returned from server");
        }
        return result;
    }

    protected String getRemoteContent(String url) {
        String string;
        HttpURLConnection conn = null;
        InputStreamReader reader = null;
        try {
            conn = this.getConnection(url, "GET");
            reader = new InputStreamReader((InputStream)conn.getContent());
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new ServerConnectionException("Status returned by url : '" + url + "' is invalid : " + statusCode);
            }
            string = IOUtils.toString((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new ServerConnectionException("url=" + url, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        if (conn != null) {
            conn.disconnect();
        }
        return string;
    }

    public String getUrl() {
        return this.url;
    }

    private HttpURLConnection getConnection(String url, String method) throws IOException {
        URL page = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.setConnectTimeout(this.connectTimeoutMiliseconds);
        conn.setReadTimeout(this.readTimeoutMiliseconds);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }

    public static class ServerConnectionException
    extends SonarException {
        public ServerConnectionException(String msg) {
            super(msg);
        }

        public ServerConnectionException(String msg, Throwable throwable) {
            super(msg, throwable);
        }
    }

    public static class ServerApiEmptyContentException
    extends SonarException {
        public ServerApiEmptyContentException(String s) {
            super(s);
        }
    }
}

