/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.AverageFormula;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.SumChildDistributionFormula;
import org.sonar.api.measures.SumChildValuesFormula;
import org.sonar.api.measures.WeightedMeanAggregationFormula;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoreMetrics {
    public static final String DOMAIN_SIZE = "Size";
    public static final String DOMAIN_TESTS = "Tests";
    public static final String DOMAIN_INTEGRATION_TESTS = "Integration Tests";
    public static final String DOMAIN_COMPLEXITY = "Complexity";
    public static final String DOMAIN_DOCUMENTATION = "Documentation";
    public static final String DOMAIN_RULES = "Rules";
    public static final String DOMAIN_SCM = "SCM";
    public static final String DOMAIN_REVIEWS = "Reviews";
    @Deprecated
    public static final String DOMAIN_RULE_CATEGORIES = "Rule categories";
    public static final String DOMAIN_GENERAL = "General";
    public static final String DOMAIN_DUPLICATION = "Duplication";
    public static final String DOMAIN_DESIGN = "Design";
    public static final String LINES_KEY = "lines";
    public static final Metric LINES = new Metric.Builder("lines", "Lines", Metric.ValueType.INT).setDescription("Lines").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String GENERATED_LINES_KEY = "generated_lines";
    public static final Metric GENERATED_LINES = new Metric.Builder("generated_lines", "Generated Lines", Metric.ValueType.INT).setDescription("Number of generated lines").setDirection(-1).setQualitative(false).setDomain("Size").setBestValue(0.0).setOptimizedBestValue(true).setFormula(new SumChildValuesFormula(false)).create();
    public static final String NCLOC_KEY = "ncloc";
    public static final Metric NCLOC = new Metric.Builder("ncloc", "Lines of code", Metric.ValueType.INT).setDescription("Non Commenting Lines of Code").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String GENERATED_NCLOC_KEY = "generated_ncloc";
    public static final Metric GENERATED_NCLOC = new Metric.Builder("generated_ncloc", "Generated lines of code", Metric.ValueType.INT).setDescription("Generated non Commenting Lines of Code").setDirection(-1).setQualitative(false).setDomain("Size").setBestValue(0.0).setOptimizedBestValue(true).setFormula(new SumChildValuesFormula(false)).create();
    public static final String CLASSES_KEY = "classes";
    public static final Metric CLASSES = new Metric.Builder("classes", "Classes", Metric.ValueType.INT).setDescription("Classes").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String FILES_KEY = "files";
    public static final Metric FILES = new Metric.Builder("files", "Files", Metric.ValueType.INT).setDescription("Number of files").setDirection(-1).setQualitative(false).setDomain("Size").create();
    public static final String DIRECTORIES_KEY = "directories";
    public static final Metric DIRECTORIES = new Metric.Builder("directories", "Directories", Metric.ValueType.INT).setDescription("Directories").setDirection(-1).setQualitative(false).setDomain("Size").create();
    public static final String PACKAGES_KEY = "packages";
    public static final Metric PACKAGES = new Metric.Builder("packages", "Packages", Metric.ValueType.INT).setDescription("Packages").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String FUNCTIONS_KEY = "functions";
    public static final Metric FUNCTIONS = new Metric.Builder("functions", "Methods", Metric.ValueType.INT).setDescription("Methods").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String ACCESSORS_KEY = "accessors";
    public static final Metric ACCESSORS = new Metric.Builder("accessors", "Accessors", Metric.ValueType.INT).setDescription("Accessors").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    @Deprecated
    public static final String PARAGRAPHS_KEY = "paragraphs";
    @Deprecated
    public static final Metric PARAGRAPHS = new Metric.Builder("paragraphs", "Paragraphs", Metric.ValueType.INT).setDescription("Number of paragraphs").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String STATEMENTS_KEY = "statements";
    public static final Metric STATEMENTS = new Metric.Builder("statements", "Statements", Metric.ValueType.INT).setDescription("Number of statements").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String PUBLIC_API_KEY = "public_api";
    public static final Metric PUBLIC_API = new Metric.Builder("public_api", "Public API", Metric.ValueType.INT).setDescription("Public API").setDirection(-1).setQualitative(false).setDomain("Size").setFormula(new SumChildValuesFormula(false)).create();
    public static final String PROJECTS_KEY = "projects";
    public static final Metric PROJECTS = new Metric.Builder("projects", "Projects", Metric.ValueType.INT).setDescription("Number of projects").setDirection(-1).setQualitative(false).setDomain("Size").create();
    public static final String COMMENT_LINES_KEY = "comment_lines";
    public static final Metric COMMENT_LINES = new Metric.Builder("comment_lines", "Comment lines", Metric.ValueType.INT).setDescription("Number of comment lines").setDirection(1).setQualitative(false).setDomain("Documentation").setFormula(new SumChildValuesFormula(false)).create();
    public static final String COMMENT_LINES_DENSITY_KEY = "comment_lines_density";
    public static final Metric COMMENT_LINES_DENSITY = new Metric.Builder("comment_lines_density", "Comments (%)", Metric.ValueType.PERCENT).setDescription("Comments balanced by ncloc + comment lines").setDirection(1).setQualitative(true).setDomain("Documentation").create();
    public static final String COMMENT_BLANK_LINES_KEY = "comment_blank_lines";
    public static final Metric COMMENT_BLANK_LINES = new Metric.Builder("comment_blank_lines", "Blank comments", Metric.ValueType.INT).setDescription("Comments that do not contain comments").setDirection(-1).setQualitative(false).setDomain("Documentation").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String PUBLIC_DOCUMENTED_API_DENSITY_KEY = "public_documented_api_density";
    public static final Metric PUBLIC_DOCUMENTED_API_DENSITY = new Metric.Builder("public_documented_api_density", "Public documented API (%)", Metric.ValueType.PERCENT).setDescription("Public documented classes and methods balanced by ncloc").setDirection(1).setQualitative(true).setDomain("Documentation").setWorstValue(0.0).setBestValue(100.0).setOptimizedBestValue(true).create();
    public static final String PUBLIC_UNDOCUMENTED_API_KEY = "public_undocumented_api";
    public static final Metric PUBLIC_UNDOCUMENTED_API = new Metric.Builder("public_undocumented_api", "Public undocumented API", Metric.ValueType.INT).setDescription("Public undocumented classes, methods and variables").setDirection(-1).setQualitative(true).setDomain("Documentation").setBestValue(0.0).setDirection(-1).setOptimizedBestValue(true).setFormula(new SumChildValuesFormula(false)).create();
    public static final String COMMENTED_OUT_CODE_LINES_KEY = "commented_out_code_lines";
    public static final Metric COMMENTED_OUT_CODE_LINES = new Metric.Builder("commented_out_code_lines", "Commented-out LOC", Metric.ValueType.INT).setDescription("Commented lines of code").setDirection(-1).setQualitative(true).setDomain("Documentation").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String COMPLEXITY_KEY = "complexity";
    public static final Metric COMPLEXITY = new Metric.Builder("complexity", "Complexity", Metric.ValueType.INT).setDescription("Cyclomatic complexity").setDirection(-1).setQualitative(false).setDomain("Complexity").setFormula(new SumChildValuesFormula(false)).create();
    public static final String CLASS_COMPLEXITY_KEY = "class_complexity";
    public static final Metric CLASS_COMPLEXITY = new Metric.Builder("class_complexity", "Complexity /class", Metric.ValueType.FLOAT).setDescription("Complexity average by class").setDirection(-1).setQualitative(true).setDomain("Complexity").setFormula(AverageFormula.create(COMPLEXITY, CLASSES)).create();
    public static final String FUNCTION_COMPLEXITY_KEY = "function_complexity";
    public static final Metric FUNCTION_COMPLEXITY = new Metric.Builder("function_complexity", "Complexity /method", Metric.ValueType.FLOAT).setDescription("Complexity average by method").setDirection(-1).setQualitative(true).setDomain("Complexity").setFormula(AverageFormula.create(COMPLEXITY, FUNCTIONS)).create();
    public static final String FILE_COMPLEXITY_KEY = "file_complexity";
    public static final Metric FILE_COMPLEXITY = new Metric.Builder("file_complexity", "Complexity /file", Metric.ValueType.FLOAT).setDescription("Complexity average by file").setDirection(-1).setQualitative(true).setDomain("Complexity").setFormula(AverageFormula.create(COMPLEXITY, FILES)).create();
    @Deprecated
    public static final String PARAGRAPH_COMPLEXITY_KEY = "paragraph_complexity";
    @Deprecated
    public static final Metric PARAGRAPH_COMPLEXITY = new Metric.Builder("paragraph_complexity", "Complexity /paragraph", Metric.ValueType.FLOAT).setDescription("Complexity average by paragraph").setDirection(-1).setQualitative(true).setDomain("Complexity").setFormula(AverageFormula.create(COMPLEXITY, PARAGRAPHS)).create();
    @Deprecated
    public static final String CLASS_COMPLEXITY_DISTRIBUTION_KEY = "class_complexity_distribution";
    @Deprecated
    public static final Metric CLASS_COMPLEXITY_DISTRIBUTION = new Metric.Builder("class_complexity_distribution", "Classes distribution /complexity", Metric.ValueType.DISTRIB).setDescription("Classes distribution /complexity").setDirection(0).setQualitative(true).setDomain("Complexity").setFormula(new SumChildDistributionFormula().setMinimumScopeToPersist("DIR")).create();
    public static final String FUNCTION_COMPLEXITY_DISTRIBUTION_KEY = "function_complexity_distribution";
    public static final Metric FUNCTION_COMPLEXITY_DISTRIBUTION = new Metric.Builder("function_complexity_distribution", "Functions distribution /complexity", Metric.ValueType.DISTRIB).setDescription("Functions distribution /complexity").setDirection(0).setQualitative(true).setDomain("Complexity").setFormula(new SumChildDistributionFormula().setMinimumScopeToPersist("DIR")).create();
    public static final String FILE_COMPLEXITY_DISTRIBUTION_KEY = "file_complexity_distribution";
    public static final Metric FILE_COMPLEXITY_DISTRIBUTION = new Metric.Builder("file_complexity_distribution", "Files distribution /complexity", Metric.ValueType.DISTRIB).setDescription("Files distribution /complexity").setDirection(0).setQualitative(true).setDomain("Complexity").setFormula(new SumChildDistributionFormula().setMinimumScopeToPersist("DIR")).create();
    @Deprecated
    public static final String PARAGRAPH_COMPLEXITY_DISTRIBUTION_KEY = "paragraph_complexity_distribution";
    @Deprecated
    public static final Metric PARAGRAPH_COMPLEXITY_DISTRIBUTION = new Metric.Builder("paragraph_complexity_distribution", "Paragraph distribution /complexity", Metric.ValueType.DISTRIB).setDescription("Paragraph distribution /complexity").setDirection(0).setQualitative(true).setDomain("Complexity").setFormula(new SumChildDistributionFormula().setMinimumScopeToPersist("DIR")).create();
    public static final String TESTS_KEY = "tests";
    public static final Metric TESTS = new Metric.Builder("tests", "Unit tests", Metric.ValueType.INT).setDescription("Number of unit tests").setDirection(-1).setQualitative(false).setDomain("Tests").create();
    public static final String TEST_EXECUTION_TIME_KEY = "test_execution_time";
    public static final Metric TEST_EXECUTION_TIME = new Metric.Builder("test_execution_time", "Unit tests duration", Metric.ValueType.MILLISEC).setDescription("Execution duration of unit tests").setDirection(-1).setQualitative(false).setDomain("Tests").create();
    public static final String TEST_ERRORS_KEY = "test_errors";
    public static final Metric TEST_ERRORS = new Metric.Builder("test_errors", "Unit test errors", Metric.ValueType.INT).setDescription("Number of unit test errors").setDirection(-1).setQualitative(true).setDomain("Tests").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String SKIPPED_TESTS_KEY = "skipped_tests";
    public static final Metric SKIPPED_TESTS = new Metric.Builder("skipped_tests", "Skipped unit tests", Metric.ValueType.INT).setDescription("Number of skipped unit tests").setDirection(-1).setQualitative(true).setDomain("Tests").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String TEST_FAILURES_KEY = "test_failures";
    public static final Metric TEST_FAILURES = new Metric.Builder("test_failures", "Unit test failures", Metric.ValueType.INT).setDescription("Number of unit test failures").setDirection(-1).setQualitative(true).setDomain("Tests").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String TEST_SUCCESS_DENSITY_KEY = "test_success_density";
    public static final Metric TEST_SUCCESS_DENSITY = new Metric.Builder("test_success_density", "Unit test success (%)", Metric.ValueType.PERCENT).setDescription("Density of successful unit tests").setDirection(1).setQualitative(true).setDomain("Tests").setWorstValue(0.0).setBestValue(100.0).setOptimizedBestValue(true).create();
    public static final String TEST_DATA_KEY = "test_data";
    public static final Metric TEST_DATA = new Metric.Builder("test_data", "Unit tests details", Metric.ValueType.DATA).setDescription("Unit tests details").setDirection(-1).setDomain("Tests").create();
    public static final String COVERAGE_KEY = "coverage";
    public static final Metric COVERAGE = new Metric.Builder("coverage", "Coverage", Metric.ValueType.PERCENT).setDescription("Coverage by unit tests").setDirection(1).setQualitative(true).setDomain("Tests").setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_COVERAGE_KEY = "new_coverage";
    public static final Metric NEW_COVERAGE = new Metric.Builder("new_coverage", "New coverage", Metric.ValueType.PERCENT).setDescription("Coverage of new/changed code").setDirection(1).setQualitative(true).setDomain("Tests").setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    public static final String LINES_TO_COVER_KEY = "lines_to_cover";
    public static final Metric LINES_TO_COVER = new Metric.Builder("lines_to_cover", "Lines to cover", Metric.ValueType.INT).setDescription("Lines to cover").setDirection(1).setQualitative(false).setDomain("Tests").setFormula(new SumChildValuesFormula(false)).create();
    public static final String NEW_LINES_TO_COVER_KEY = "new_lines_to_cover";
    public static final Metric NEW_LINES_TO_COVER = new Metric.Builder("new_lines_to_cover", "New lines to cover", Metric.ValueType.INT).setDescription("New lines to cover").setDirection(-1).setQualitative(false).setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setDeleteHistoricalData(true).create();
    public static final String UNCOVERED_LINES_KEY = "uncovered_lines";
    public static final Metric UNCOVERED_LINES = new Metric.Builder("uncovered_lines", "Uncovered lines", Metric.ValueType.INT).setDescription("Uncovered lines").setDirection(-1).setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).create();
    public static final String NEW_UNCOVERED_LINES_KEY = "new_uncovered_lines";
    public static final Metric NEW_UNCOVERED_LINES = new Metric.Builder("new_uncovered_lines", "New uncovered lines", Metric.ValueType.INT).setDescription("New uncovered lines").setDirection(-1).setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String LINE_COVERAGE_KEY = "line_coverage";
    public static final Metric LINE_COVERAGE = new Metric.Builder("line_coverage", "Line coverage", Metric.ValueType.PERCENT).setDescription("Line coverage").setDirection(1).setQualitative(true).setDomain("Tests").setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_LINE_COVERAGE_KEY = "new_line_coverage";
    public static final Metric NEW_LINE_COVERAGE = new Metric.Builder("new_line_coverage", "New line coverage", Metric.ValueType.PERCENT).setDescription("Line coverage of added/changed code").setDirection(1).setQualitative(true).setWorstValue(0.0).setBestValue(100.0).setDomain("Tests").setDeleteHistoricalData(true).create();
    public static final String COVERAGE_LINE_HITS_DATA_KEY = "coverage_line_hits_data";
    public static final Metric COVERAGE_LINE_HITS_DATA = new Metric.Builder("coverage_line_hits_data", "Coverage hits by line", Metric.ValueType.DATA).setDomain("Tests").setDeleteHistoricalData(true).create();
    public static final String CONDITIONS_TO_COVER_KEY = "conditions_to_cover";
    public static final Metric CONDITIONS_TO_COVER = new Metric.Builder("conditions_to_cover", "Conditions to cover", Metric.ValueType.INT).setDescription("Conditions to cover").setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setHidden(true).setDeleteHistoricalData(true).create();
    public static final String NEW_CONDITIONS_TO_COVER_KEY = "new_conditions_to_cover";
    public static final Metric NEW_CONDITIONS_TO_COVER = new Metric.Builder("new_conditions_to_cover", "New conditions to cover", Metric.ValueType.INT).setDescription("New conditions to cover").setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setDeleteHistoricalData(true).create();
    public static final String UNCOVERED_CONDITIONS_KEY = "uncovered_conditions";
    public static final Metric UNCOVERED_CONDITIONS = new Metric.Builder("uncovered_conditions", "Uncovered conditions", Metric.ValueType.INT).setDescription("Uncovered conditions").setDirection(-1).setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).create();
    public static final String NEW_UNCOVERED_CONDITIONS_KEY = "new_uncovered_conditions";
    public static final Metric NEW_UNCOVERED_CONDITIONS = new Metric.Builder("new_uncovered_conditions", "New uncovered conditions", Metric.ValueType.INT).setDescription("New uncovered conditions").setDirection(-1).setDomain("Tests").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String BRANCH_COVERAGE_KEY = "branch_coverage";
    public static final Metric BRANCH_COVERAGE = new Metric.Builder("branch_coverage", "Branch coverage", Metric.ValueType.PERCENT).setDescription("Branch coverage").setDirection(1).setQualitative(true).setDomain("Tests").setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_BRANCH_COVERAGE_KEY = "new_branch_coverage";
    public static final Metric NEW_BRANCH_COVERAGE = new Metric.Builder("new_branch_coverage", "New branch coverage", Metric.ValueType.PERCENT).setDescription("Branch coverage of new/changed code").setDirection(1).setQualitative(true).setDomain("Tests").setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String BRANCH_COVERAGE_HITS_DATA_KEY = "branch_coverage_hits_data";
    @Deprecated
    public static final Metric BRANCH_COVERAGE_HITS_DATA = new Metric.Builder("branch_coverage_hits_data", "Branch coverage hits", Metric.ValueType.DATA).setDomain("Tests").setDeleteHistoricalData(true).create();
    public static final String CONDITIONS_BY_LINE_KEY = "conditions_by_line";
    public static final Metric CONDITIONS_BY_LINE = new Metric.Builder("conditions_by_line", "Conditions by line", Metric.ValueType.DATA).setDomain("Tests").setDeleteHistoricalData(true).create();
    public static final String COVERED_CONDITIONS_BY_LINE_KEY = "covered_conditions_by_line";
    public static final Metric COVERED_CONDITIONS_BY_LINE = new Metric.Builder("covered_conditions_by_line", "Covered conditions by line", Metric.ValueType.DATA).setDomain("Tests").setDeleteHistoricalData(true).create();
    public static final String IT_COVERAGE_KEY = "it_coverage";
    public static final Metric IT_COVERAGE = new Metric.Builder("it_coverage", "IT Coverage", Metric.ValueType.PERCENT).setDescription("Coverage by integration tests").setDirection(1).setQualitative(true).setDomain("Integration Tests").setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_IT_COVERAGE_KEY = "new_it_coverage";
    public static final Metric NEW_IT_COVERAGE = new Metric.Builder("new_it_coverage", "New Coverage by IT", Metric.ValueType.PERCENT).setDescription("Integration Tests Coverage of new/changed code").setDirection(1).setQualitative(true).setDomain("Integration Tests").setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    public static final String IT_LINES_TO_COVER_KEY = "it_lines_to_cover";
    public static final Metric IT_LINES_TO_COVER = new Metric.Builder("it_lines_to_cover", "IT Lines to Cover", Metric.ValueType.INT).setDescription("Lines to cover by Integration Tests").setDirection(1).setDomain("Integration Tests").setQualitative(false).setFormula(new SumChildValuesFormula(false)).setHidden(true).setDeleteHistoricalData(true).create();
    public static final String NEW_IT_LINES_TO_COVER_KEY = "new_it_lines_to_cover";
    public static final Metric NEW_IT_LINES_TO_COVER = new Metric.Builder("new_it_lines_to_cover", "New Lines to Cover by IT", Metric.ValueType.INT).setDescription("New lines to cover by Integration Tests").setDirection(-1).setQualitative(false).setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).setDeleteHistoricalData(true).create();
    public static final String IT_UNCOVERED_LINES_KEY = "it_uncovered_lines";
    public static final Metric IT_UNCOVERED_LINES = new Metric.Builder("it_uncovered_lines", "IT Uncovered Lines", Metric.ValueType.INT).setDescription("IT uncovered lines").setDirection(-1).setQualitative(false).setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).create();
    public static final String NEW_IT_UNCOVERED_LINES_KEY = "new_it_uncovered_lines";
    public static final Metric NEW_IT_UNCOVERED_LINES = new Metric.Builder("new_it_uncovered_lines", "New Uncovered Lines by IT", Metric.ValueType.INT).setDescription("New uncovered lines by Integration Tests").setDirection(-1).setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String IT_LINE_COVERAGE_KEY = "it_line_coverage";
    public static final Metric IT_LINE_COVERAGE = new Metric.Builder("it_line_coverage", "IT Line coverage", Metric.ValueType.PERCENT).setDescription("IT line coverage").setDirection(1).setQualitative(true).setDomain("Integration Tests").create();
    public static final String NEW_IT_LINE_COVERAGE_KEY = "new_it_line_coverage";
    public static final Metric NEW_IT_LINE_COVERAGE = new Metric.Builder("new_it_line_coverage", "New Line Coverage by IT", Metric.ValueType.PERCENT).setDescription("Line Coverage by Integration Tests of added/changed code").setDirection(1).setQualitative(true).setWorstValue(0.0).setBestValue(100.0).setDomain("Integration Tests").setDeleteHistoricalData(true).create();
    public static final String IT_COVERAGE_LINE_HITS_DATA_KEY = "it_coverage_line_hits_data";
    public static final Metric IT_COVERAGE_LINE_HITS_DATA = new Metric.Builder("it_coverage_line_hits_data", "IT Coverage Hits Data", Metric.ValueType.DATA).setDescription("IT Code coverage line hits data").setDirection(0).setQualitative(false).setDomain("Integration Tests").setDeleteHistoricalData(true).create();
    public static final String IT_CONDITIONS_TO_COVER_KEY = "it_conditions_to_cover";
    public static final Metric IT_CONDITIONS_TO_COVER = new Metric.Builder("it_conditions_to_cover", "IT Branches to Cover", Metric.ValueType.INT).setDescription("IT Conditions to cover").setDirection(1).setQualitative(false).setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).setHidden(true).setDeleteHistoricalData(true).create();
    public static final String NEW_IT_CONDITIONS_TO_COVER_KEY = "new_it_conditions_to_cover";
    public static final Metric NEW_IT_CONDITIONS_TO_COVER = new Metric.Builder("new_it_conditions_to_cover", "New Conditions to Cover by IT", Metric.ValueType.INT).setDescription("New conditions to cover by Integration Tests").setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).setDeleteHistoricalData(true).create();
    public static final String IT_UNCOVERED_CONDITIONS_KEY = "it_uncovered_conditions";
    public static final Metric IT_UNCOVERED_CONDITIONS = new Metric.Builder("it_uncovered_conditions", "IT Uncovered Branches", Metric.ValueType.INT).setDescription("IT Uncovered conditions").setDirection(-1).setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).create();
    public static final String NEW_IT_UNCOVERED_CONDITIONS_KEY = "new_it_uncovered_conditions";
    public static final Metric NEW_IT_UNCOVERED_CONDITIONS = new Metric.Builder("new_it_uncovered_conditions", "New Uncovered Conditions by IT", Metric.ValueType.INT).setDescription("New uncovered conditions by Integration Tests").setDirection(-1).setDomain("Integration Tests").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String IT_BRANCH_COVERAGE_KEY = "it_branch_coverage";
    public static final Metric IT_BRANCH_COVERAGE = new Metric.Builder("it_branch_coverage", "IT Branch Coverage", Metric.ValueType.PERCENT).setDescription("IT Branch coverage").setDirection(1).setQualitative(true).setDomain("Integration Tests").setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_IT_BRANCH_COVERAGE_KEY = "new_it_branch_coverage";
    public static final Metric NEW_IT_BRANCH_COVERAGE = new Metric.Builder("new_it_branch_coverage", "New Branch Coverage by IT", Metric.ValueType.PERCENT).setDescription("Branch coverage by Integration Tests of new/changed code").setDirection(1).setQualitative(true).setDomain("Integration Tests").setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    public static final String IT_CONDITIONS_BY_LINE_KEY = "it_conditions_by_line";
    public static final Metric IT_CONDITIONS_BY_LINE = new Metric.Builder("it_conditions_by_line", "IT Branches by Line", Metric.ValueType.DATA).setDomain("Integration Tests").setDeleteHistoricalData(true).create();
    public static final String IT_COVERED_CONDITIONS_BY_LINE_KEY = "it_covered_conditions_by_line";
    public static final Metric IT_COVERED_CONDITIONS_BY_LINE = new Metric.Builder("it_covered_conditions_by_line", "IT Covered Branches by Line", Metric.ValueType.DATA).setDomain("Integration Tests").setDeleteHistoricalData(true).create();
    public static final String DUPLICATED_LINES_KEY = "duplicated_lines";
    public static final Metric DUPLICATED_LINES = new Metric.Builder("duplicated_lines", "Duplicated lines", Metric.ValueType.INT).setDescription("Duplicated lines").setDirection(-1).setQualitative(true).setDomain("Duplication").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String DUPLICATED_BLOCKS_KEY = "duplicated_blocks";
    public static final Metric DUPLICATED_BLOCKS = new Metric.Builder("duplicated_blocks", "Duplicated blocks", Metric.ValueType.INT).setDescription("Duplicated blocks").setDirection(-1).setQualitative(true).setDomain("Duplication").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String DUPLICATED_FILES_KEY = "duplicated_files";
    public static final Metric DUPLICATED_FILES = new Metric.Builder("duplicated_files", "Duplicated files", Metric.ValueType.INT).setDescription("Duplicated files").setDirection(-1).setQualitative(true).setDomain("Duplication").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String DUPLICATED_LINES_DENSITY_KEY = "duplicated_lines_density";
    public static final Metric DUPLICATED_LINES_DENSITY = new Metric.Builder("duplicated_lines_density", "Duplicated lines (%)", Metric.ValueType.PERCENT).setDescription("Duplicated lines balanced by statements").setDirection(-1).setQualitative(true).setDomain("Duplication").setWorstValue(50.0).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String DUPLICATIONS_DATA_KEY = "duplications_data";
    public static final Metric DUPLICATIONS_DATA = new Metric.Builder("duplications_data", "Duplications details", Metric.ValueType.DATA).setDescription("Duplications details").setDirection(0).setQualitative(false).setDomain("Duplication").setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String USABILITY_KEY = "usability";
    @Deprecated
    public static final Metric USABILITY = new Metric("usability", "Usability", "Usability", Metric.ValueType.PERCENT, 1, true, "Rule categories").setBestValue(100.0).setOptimizedBestValue(true);
    @Deprecated
    public static final String RELIABILITY_KEY = "reliability";
    @Deprecated
    public static final Metric RELIABILITY = new Metric("reliability", "Reliability", "Reliability", Metric.ValueType.PERCENT, 1, true, "Rule categories").setBestValue(100.0).setOptimizedBestValue(true);
    @Deprecated
    public static final String EFFICIENCY_KEY = "efficiency";
    @Deprecated
    public static final Metric EFFICIENCY = new Metric("efficiency", "Efficiency", "Efficiency", Metric.ValueType.PERCENT, 1, true, "Rule categories").setBestValue(100.0).setOptimizedBestValue(true);
    @Deprecated
    public static final String PORTABILITY_KEY = "portability";
    @Deprecated
    public static final Metric PORTABILITY = new Metric("portability", "Portability", "Portability", Metric.ValueType.PERCENT, 1, true, "Rule categories").setBestValue(100.0).setOptimizedBestValue(true);
    @Deprecated
    public static final String MAINTAINABILITY_KEY = "maintainability";
    @Deprecated
    public static final Metric MAINTAINABILITY = new Metric.Builder("maintainability", "Maintainability", Metric.ValueType.PERCENT).setDescription("Maintainability").setDirection(1).setQualitative(true).setDomain("Rule categories").setBestValue(100.0).setOptimizedBestValue(true).create();
    public static final String WEIGHTED_VIOLATIONS_KEY = "weighted_violations";
    public static final Metric WEIGHTED_VIOLATIONS = new Metric.Builder("weighted_violations", "Weighted violations", Metric.ValueType.INT).setDescription("Weighted Violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String VIOLATIONS_DENSITY_KEY = "violations_density";
    public static final Metric VIOLATIONS_DENSITY = new Metric.Builder("violations_density", "Rules compliance", Metric.ValueType.PERCENT).setDescription("Rules compliance").setDirection(1).setQualitative(true).setDomain("Rules").create();
    public static final String VIOLATIONS_KEY = "violations";
    public static final Metric VIOLATIONS = new Metric.Builder("violations", "Violations", Metric.ValueType.INT).setDescription("Violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String BLOCKER_VIOLATIONS_KEY = "blocker_violations";
    public static final Metric BLOCKER_VIOLATIONS = new Metric.Builder("blocker_violations", "Blocker violations", Metric.ValueType.INT).setDescription("Blocker violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String CRITICAL_VIOLATIONS_KEY = "critical_violations";
    public static final Metric CRITICAL_VIOLATIONS = new Metric.Builder("critical_violations", "Critical violations", Metric.ValueType.INT).setDescription("Critical violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String MAJOR_VIOLATIONS_KEY = "major_violations";
    public static final Metric MAJOR_VIOLATIONS = new Metric.Builder("major_violations", "Major violations", Metric.ValueType.INT).setDescription("Major violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String MINOR_VIOLATIONS_KEY = "minor_violations";
    public static final Metric MINOR_VIOLATIONS = new Metric.Builder("minor_violations", "Minor violations", Metric.ValueType.INT).setDescription("Minor violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String INFO_VIOLATIONS_KEY = "info_violations";
    public static final Metric INFO_VIOLATIONS = new Metric.Builder("info_violations", "Info violations", Metric.ValueType.INT).setDescription("Info violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_VIOLATIONS_KEY = "new_violations";
    public static final Metric NEW_VIOLATIONS = new Metric.Builder("new_violations", "New Violations", Metric.ValueType.INT).setDescription("New Violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_BLOCKER_VIOLATIONS_KEY = "new_blocker_violations";
    public static final Metric NEW_BLOCKER_VIOLATIONS = new Metric.Builder("new_blocker_violations", "New Blocker violations", Metric.ValueType.INT).setDescription("New Blocker violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_CRITICAL_VIOLATIONS_KEY = "new_critical_violations";
    public static final Metric NEW_CRITICAL_VIOLATIONS = new Metric.Builder("new_critical_violations", "New Critical violations", Metric.ValueType.INT).setDescription("New Critical violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_MAJOR_VIOLATIONS_KEY = "new_major_violations";
    public static final Metric NEW_MAJOR_VIOLATIONS = new Metric.Builder("new_major_violations", "New Major violations", Metric.ValueType.INT).setDescription("New Major violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_MINOR_VIOLATIONS_KEY = "new_minor_violations";
    public static final Metric NEW_MINOR_VIOLATIONS = new Metric.Builder("new_minor_violations", "New Minor violations", Metric.ValueType.INT).setDescription("New Minor violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_INFO_VIOLATIONS_KEY = "new_info_violations";
    public static final Metric NEW_INFO_VIOLATIONS = new Metric.Builder("new_info_violations", "New Info violations", Metric.ValueType.INT).setDescription("New Info violations").setDirection(-1).setQualitative(true).setDomain("Rules").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String ABSTRACTNESS_KEY = "abstractness";
    public static final Metric ABSTRACTNESS = new Metric.Builder("abstractness", "Abstractness", Metric.ValueType.PERCENT).setDescription("Abstractness").setDirection(0).setQualitative(false).setDomain("Design").create();
    public static final String INSTABILITY_KEY = "instability";
    public static final Metric INSTABILITY = new Metric.Builder("instability", "Instability", Metric.ValueType.PERCENT).setDescription("Instability").setDirection(0).setQualitative(false).setDomain("Design").create();
    public static final String DISTANCE_KEY = "distance";
    public static final Metric DISTANCE = new Metric.Builder("distance", "Distance", Metric.ValueType.FLOAT).setDescription("Distance").setDirection(0).setQualitative(false).setDomain("Design").create();
    public static final String DEPTH_IN_TREE_KEY = "dit";
    public static final Metric DEPTH_IN_TREE = new Metric.Builder("dit", "Depth in Tree", Metric.ValueType.INT).setDescription("Depth in Inheritance Tree").setDirection(0).setQualitative(false).setDomain("Design").create();
    public static final String NUMBER_OF_CHILDREN_KEY = "noc";
    public static final Metric NUMBER_OF_CHILDREN = new Metric.Builder("noc", "Number of Children", Metric.ValueType.INT).setDescription("Number of Children").setDirection(0).setQualitative(false).setDomain("Design").create();
    public static final String RFC_KEY = "rfc";
    public static final Metric RFC = new Metric.Builder("rfc", "RFC", Metric.ValueType.INT).setDescription("Response for Class").setDirection(-1).setQualitative(false).setDomain("Design").setFormula(new WeightedMeanAggregationFormula(FILES, false)).create();
    public static final String RFC_DISTRIBUTION_KEY = "rfc_distribution";
    public static final Metric RFC_DISTRIBUTION = new Metric.Builder("rfc_distribution", "Class distribution /RFC", Metric.ValueType.DISTRIB).setDescription("Class distribution /RFC").setDirection(0).setQualitative(true).setDomain("Design").setFormula(new SumChildDistributionFormula().setMinimumScopeToPersist("DIR")).create();
    public static final String LCOM4_KEY = "lcom4";
    public static final Metric LCOM4 = new Metric.Builder("lcom4", "LCOM4", Metric.ValueType.FLOAT).setDescription("Lack of Cohesion of Methods").setDirection(-1).setQualitative(true).setDomain("Design").setBestValue(1.0).setFormula(new WeightedMeanAggregationFormula(FILES, false)).create();
    public static final String LCOM4_BLOCKS_KEY = "lcom4_blocks";
    public static final Metric LCOM4_BLOCKS = new Metric.Builder("lcom4_blocks", "LCOM4 blocks", Metric.ValueType.DATA).setDescription("LCOM4 blocks").setDirection(0).setQualitative(false).setDomain("Design").setHidden(true).setDeleteHistoricalData(true).create();
    public static final String LCOM4_DISTRIBUTION_KEY = "lcom4_distribution";
    public static final Metric LCOM4_DISTRIBUTION = new Metric.Builder("lcom4_distribution", "Class distribution /LCOM4", Metric.ValueType.DISTRIB).setDescription("Class distribution /LCOM4").setDirection(0).setQualitative(true).setDomain("Design").setFormula(new SumChildDistributionFormula().setMinimumScopeToPersist("DIR")).create();
    public static final String SUSPECT_LCOM4_DENSITY_KEY = "suspect_lcom4_density";
    public static final Metric SUSPECT_LCOM4_DENSITY = new Metric.Builder("suspect_lcom4_density", "Suspect LCOM4 density", Metric.ValueType.PERCENT).setDescription("Density of classes having LCOM4>1").setDirection(-1).setQualitative(true).setDomain("Design").create();
    public static final String AFFERENT_COUPLINGS_KEY = "ca";
    public static final Metric AFFERENT_COUPLINGS = new Metric.Builder("ca", "Afferent couplings", Metric.ValueType.INT).setDescription("Afferent couplings").setDirection(-1).setQualitative(false).setDomain("Design").create();
    public static final String EFFERENT_COUPLINGS_KEY = "ce";
    public static final Metric EFFERENT_COUPLINGS = new Metric.Builder("ce", "Efferent couplings", Metric.ValueType.INT).setDescription("Efferent couplings").setDirection(-1).setQualitative(false).setDomain("Design").create();
    public static final String DEPENDENCY_MATRIX_KEY = "dsm";
    public static final Metric DEPENDENCY_MATRIX = new Metric.Builder("dsm", "Dependency Matrix", Metric.ValueType.DATA).setDescription("Dependency Matrix").setDirection(0).setQualitative(false).setDomain("Design").setDeleteHistoricalData(true).create();
    public static final String PACKAGE_CYCLES_KEY = "package_cycles";
    public static final Metric PACKAGE_CYCLES = new Metric.Builder("package_cycles", "Package cycles", Metric.ValueType.INT).setDescription("Package cycles").setDirection(-1).setQualitative(true).setDomain("Design").setBestValue(0.0).setFormula(new SumChildValuesFormula(false)).create();
    public static final String PACKAGE_TANGLE_INDEX_KEY = "package_tangle_index";
    public static final Metric PACKAGE_TANGLE_INDEX = new Metric.Builder("package_tangle_index", "Package tangle index", Metric.ValueType.PERCENT).setDescription("Package tangle index").setDirection(-1).setQualitative(true).setBestValue(0.0).setDomain("Design").create();
    public static final String PACKAGE_TANGLES_KEY = "package_tangles";
    public static final Metric PACKAGE_TANGLES = new Metric.Builder("package_tangles", "File dependencies to cut", Metric.ValueType.INT).setDescription("File dependencies to cut").setDirection(-1).setQualitative(false).setDomain("Design").setFormula(new SumChildValuesFormula(false)).create();
    public static final String PACKAGE_FEEDBACK_EDGES_KEY = "package_feedback_edges";
    public static final Metric PACKAGE_FEEDBACK_EDGES = new Metric.Builder("package_feedback_edges", "Package dependencies to cut", Metric.ValueType.INT).setDescription("Package dependencies to cut").setDirection(-1).setQualitative(false).setDomain("Design").setFormula(new SumChildValuesFormula(false)).setBestValue(0.0).create();
    public static final String PACKAGE_EDGES_WEIGHT_KEY = "package_edges_weight";
    public static final Metric PACKAGE_EDGES_WEIGHT = new Metric.Builder("package_edges_weight", "Package edges weight", Metric.ValueType.INT).setDescription("Package edges weight").setDirection(1).setQualitative(false).setDomain("Design").setFormula(new SumChildValuesFormula(false)).setHidden(true).setDeleteHistoricalData(true).create();
    public static final String FILE_CYCLES_KEY = "file_cycles";
    public static final Metric FILE_CYCLES = new Metric.Builder("file_cycles", "File cycles", Metric.ValueType.INT).setDescription("File cycles").setDirection(-1).setQualitative(true).setDomain("Design").setHidden(true).setDeleteHistoricalData(true).setBestValue(0.0).create();
    public static final String FILE_TANGLE_INDEX_KEY = "file_tangle_index";
    public static final Metric FILE_TANGLE_INDEX = new Metric.Builder("file_tangle_index", "File tangle index", Metric.ValueType.PERCENT).setDescription("File tangle index").setDirection(-1).setQualitative(true).setDomain("Design").setHidden(true).setDeleteHistoricalData(true).setBestValue(0.0).create();
    public static final String FILE_TANGLES_KEY = "file_tangles";
    public static final Metric FILE_TANGLES = new Metric.Builder("file_tangles", "File tangles", Metric.ValueType.INT).setDescription("Files tangles").setDirection(-1).setQualitative(false).setDomain("Design").setHidden(true).setDeleteHistoricalData(true).create();
    public static final String FILE_FEEDBACK_EDGES_KEY = "file_feedback_edges";
    public static final Metric FILE_FEEDBACK_EDGES = new Metric.Builder("file_feedback_edges", "Suspect file dependencies", Metric.ValueType.INT).setDescription("Suspect file dependencies").setDirection(-1).setQualitative(false).setDomain("Design").setHidden(true).setDeleteHistoricalData(true).setBestValue(0.0).create();
    public static final String FILE_EDGES_WEIGHT_KEY = "file_edges_weight";
    public static final Metric FILE_EDGES_WEIGHT = new Metric.Builder("file_edges_weight", "File edges weight", Metric.ValueType.INT).setDescription("File edges weight").setDirection(1).setQualitative(false).setDomain("Design").setHidden(true).setDeleteHistoricalData(true).create();
    public static final String SCM_COMMITS_KEY = "commits";
    public static final Metric SCM_COMMITS = new Metric.Builder("commits", "Commits", Metric.ValueType.INT).setDomain("SCM").create();
    public static final String SCM_LAST_COMMIT_DATE_KEY = "last_commit_date";
    public static final Metric SCM_LAST_COMMIT_DATE = new Metric.Builder("last_commit_date", "Last commit", Metric.ValueType.STRING).setDomain("SCM").create();
    public static final String SCM_REVISION_KEY = "revision";
    public static final Metric SCM_REVISION = new Metric.Builder("revision", "Revision", Metric.ValueType.STRING).setDomain("SCM").setHidden(true).create();
    public static final String SCM_AUTHORS_BY_LINE_KEY = "authors_by_line";
    public static final Metric SCM_AUTHORS_BY_LINE = new Metric.Builder("authors_by_line", "Authors by line", Metric.ValueType.DATA).setDomain("SCM").create();
    public static final String SCM_REVISIONS_BY_LINE_KEY = "revisions_by_line";
    public static final Metric SCM_REVISIONS_BY_LINE = new Metric.Builder("revisions_by_line", "Revisions by line", Metric.ValueType.DATA).setDomain("SCM").create();
    public static final String SCM_LAST_COMMIT_DATETIMES_BY_LINE_KEY = "last_commit_datetimes_by_line";
    public static final Metric SCM_LAST_COMMIT_DATETIMES_BY_LINE = new Metric.Builder("last_commit_datetimes_by_line", "Last commit dates by line", Metric.ValueType.DATA).setDomain("SCM").create();
    public static final String UNREVIEWED_VIOLATIONS_KEY = "unreviewed_violations";
    public static final Metric UNREVIEWED_VIOLATIONS = new Metric.Builder("unreviewed_violations", "Unreviewed violations", Metric.ValueType.INT).setDescription("Violations that have not been reviewed yet").setDirection(-1).setDomain("Reviews").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_UNREVIEWED_VIOLATIONS_KEY = "new_unreviewed_violations";
    public static final Metric NEW_UNREVIEWED_VIOLATIONS = new Metric.Builder("new_unreviewed_violations", "New unreviewed violations", Metric.ValueType.INT).setDescription("New violations that have not been reviewed yet").setDirection(-1).setQualitative(true).setDomain("Reviews").setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String FALSE_POSITIVE_REVIEWS_KEY = "false_positive_reviews";
    public static final Metric FALSE_POSITIVE_REVIEWS = new Metric.Builder("false_positive_reviews", "False-positive reviews", Metric.ValueType.INT).setDescription("Active false-positive reviews").setDirection(-1).setDomain("Reviews").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String ACTIVE_REVIEWS_KEY = "active_reviews";
    public static final Metric ACTIVE_REVIEWS = new Metric.Builder("active_reviews", "Active reviews", Metric.ValueType.INT).setDescription("Active open and reopened reviews").setDirection(-1).setDomain("Reviews").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String UNASSIGNED_REVIEWS_KEY = "unassigned_reviews";
    public static final Metric UNASSIGNED_REVIEWS = new Metric.Builder("unassigned_reviews", "Unassigned reviews", Metric.ValueType.INT).setDescription("Active unassigned reviews").setDirection(-1).setDomain("Reviews").setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String UNPLANNED_REVIEWS_KEY = "unplanned_reviews";
    public static final Metric UNPLANNED_REVIEWS = new Metric.Builder("unplanned_reviews", "Unplanned reviews", Metric.ValueType.INT).setDescription("Active unplanned reviews").setDirection(-1).setDomain("Reviews").setBestValue(0.0).setOptimizedBestValue(true).create();
    @Beta
    public static final String NCLOC_DATA_KEY = "ncloc_data";
    @Beta
    public static final Metric NCLOC_DATA = new Metric.Builder("ncloc_data", "ncloc_data", Metric.ValueType.DATA).setHidden(true).setDomain("Size").create();
    @Beta
    public static final String COMMENT_LINES_DATA_KEY = "comment_lines_data";
    @Beta
    public static final Metric COMMENT_LINES_DATA = new Metric.Builder("comment_lines_data", "comment_lines_data", Metric.ValueType.DATA).setHidden(true).setDomain("Documentation").create();
    public static final String ALERT_STATUS_KEY = "alert_status";
    public static final Metric ALERT_STATUS = new Metric.Builder("alert_status", "Alert", Metric.ValueType.LEVEL).setDescription("Alert").setDirection(1).setQualitative(true).setDomain("General").create();
    public static final String PROFILE_KEY = "profile";
    public static final Metric PROFILE = new Metric.Builder("profile", "Profile", Metric.ValueType.DATA).setDescription("Selected quality profile").setDomain("General").create();
    public static final String PROFILE_VERSION_KEY = "profile_version";
    public static final Metric PROFILE_VERSION = new Metric.Builder("profile_version", "Profile version", Metric.ValueType.INT).setDescription("Selected quality profile version").setQualitative(false).setDomain("General").create();
    private static final List<Metric> METRICS = Lists.newLinkedList();

    private CoreMetrics() {
    }

    public static List<Metric> getMetrics() {
        return METRICS;
    }

    static {
        for (Field field : CoreMetrics.class.getFields()) {
            if (!Metric.class.isAssignableFrom(field.getType())) continue;
            try {
                Metric metric = (Metric)field.get(null);
                if (StringUtils.equals((String)metric.getDomain(), (String)DOMAIN_RULE_CATEGORIES)) continue;
                METRICS.add(metric);
            }
            catch (IllegalAccessException e) {
                throw new SonarException("can not introspect " + CoreMetrics.class + " to get metrics", e);
            }
        }
    }
}

