/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.charts;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Values2D;
import org.sonar.api.charts.Chart;
import org.sonar.api.charts.ChartParameters;

public abstract class AbstractChart
implements Chart {
    public static final int FONT_SIZE = 13;
    public static final Color OUTLINE_COLOR = new Color(51, 51, 51);
    public static final Color GRID_COLOR = new Color(204, 204, 204);
    public static final Color[] COLORS = new Color[]{Color.decode("#4192D9"), Color.decode("#800000"), Color.decode("#A7B307"), Color.decode("#913C9F"), Color.decode("#329F4D")};

    protected abstract Plot getPlot(ChartParameters var1);

    protected boolean hasLegend() {
        return false;
    }

    public BufferedImage generateImage(ChartParameters params) {
        JFreeChart chart = new JFreeChart(null, TextTitle.DEFAULT_FONT, this.getPlot(params), this.hasLegend());
        this.improveChart(chart, params);
        return chart.createBufferedImage(params.getWidth(), params.getHeight());
    }

    private void improveChart(JFreeChart jfrechart, ChartParameters params) {
        Color background = Color.decode("#" + params.getValue("bgc", "FFFFFF", false));
        jfrechart.setBackgroundPaint((Paint)background);
        jfrechart.setBorderVisible(false);
        jfrechart.setAntiAlias(true);
        jfrechart.setTextAntiAlias(true);
        jfrechart.removeLegend();
    }

    public String toString() {
        return this.getKey();
    }

    protected void configureColors(Values2D dataset, CategoryPlot plot, String[] colorsHex) {
        Color[] colors = COLORS;
        if (colorsHex != null && colorsHex.length > 0) {
            colors = new Color[colorsHex.length];
            for (int i = 0; i < colorsHex.length; ++i) {
                colors[i] = Color.decode("#" + colorsHex[i]);
            }
        }
        dataset.getColumnCount();
        AbstractRenderer renderer = (AbstractRenderer)plot.getRenderer();
        for (int i = 0; i < dataset.getColumnCount(); ++i) {
            renderer.setSeriesPaint(i, (Paint)colors[i % colors.length]);
        }
    }
}

