/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class WildcardPattern {
    private static final Map<String, WildcardPattern> patterns = new HashMap<String, WildcardPattern>();
    private Pattern pattern;
    private String stringRepresentation;

    protected WildcardPattern(String pattern, String directorySeparator) {
        this.stringRepresentation = pattern;
        this.pattern = Pattern.compile(this.toRegexp(pattern, directorySeparator));
    }

    public boolean match(String value) {
        return this.pattern.matcher(this.removeSlahesToIgnore(value)).matches();
    }

    private String toRegexp(String wildcardPattern, String directorySeparator) {
        String patternStr = this.removeSlahesToIgnore(wildcardPattern);
        patternStr = StringUtils.replace((String)patternStr, (String)"**/**", (String)"**");
        patternStr = StringUtils.replace((String)patternStr, (String)"**/", (String)"(&/|)");
        patternStr = StringUtils.replace((String)patternStr, (String)"/**", (String)"/&");
        patternStr = StringUtils.replace((String)patternStr, (String)"**", (String)"&");
        StringBuilder sb = new StringBuilder();
        block7: for (char c : patternStr.toCharArray()) {
            switch (c) {
                case '&': {
                    sb.append(".*");
                    continue block7;
                }
                case '*': {
                    sb.append("[^\\").append(directorySeparator).append("]*");
                    continue block7;
                }
                case '?': {
                    sb.append("[^\\").append(directorySeparator).append("]");
                    continue block7;
                }
                case '.': {
                    sb.append("\\.");
                    continue block7;
                }
                case '/': {
                    sb.append("\\").append(directorySeparator);
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String removeSlahesToIgnore(String wildcardPattern) {
        String patternStr = StringUtils.removeStart((String)wildcardPattern, (String)"/");
        return StringUtils.removeEnd((String)patternStr, (String)"/");
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public static boolean match(WildcardPattern[] patterns, String value) {
        for (WildcardPattern pattern : patterns) {
            if (!pattern.match(value)) continue;
            return true;
        }
        return false;
    }

    public static WildcardPattern create(String pattern) {
        return WildcardPattern.create(pattern, "/");
    }

    public static WildcardPattern[] create(String[] patterns) {
        if (patterns == null) {
            return new WildcardPattern[0];
        }
        WildcardPattern[] exclusionPAtterns = new WildcardPattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            exclusionPAtterns[i] = WildcardPattern.create(patterns[i]);
        }
        return exclusionPAtterns;
    }

    public static WildcardPattern create(String pattern, String directorySeparator) {
        String key = pattern + directorySeparator;
        WildcardPattern wildcardPattern = patterns.get(key);
        if (wildcardPattern == null) {
            wildcardPattern = new WildcardPattern(pattern, directorySeparator);
            patterns.put(key, wildcardPattern);
        }
        return wildcardPattern;
    }
}

