/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.rules.Iso9126RulesCategories;
import org.sonar.check.IsoCategory;

@Deprecated
@Immutable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
@Entity
@Table(name="rules_categories")
public class RulesCategory
extends BaseIdentifiable {
    @Column(name="name", updatable=false, nullable=false)
    private String name;
    @Column(name="description", updatable=false, nullable=true)
    private String description;

    public RulesCategory(String name) {
        this.name = name;
    }

    public RulesCategory(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public RulesCategory() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RulesCategory)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RulesCategory other = (RulesCategory)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)other.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.name).append("desc", (Object)this.description).toString();
    }

    public IsoCategory toIsoCategory() {
        if (this.name.equals(Iso9126RulesCategories.EFFICIENCY.getName())) {
            return IsoCategory.Efficiency;
        }
        if (this.name.equals(Iso9126RulesCategories.MAINTAINABILITY.getName())) {
            return IsoCategory.Maintainability;
        }
        if (this.name.equals(Iso9126RulesCategories.PORTABILITY.getName())) {
            return IsoCategory.Portability;
        }
        if (this.name.equals(Iso9126RulesCategories.RELIABILITY.getName())) {
            return IsoCategory.Reliability;
        }
        if (this.name.equals(Iso9126RulesCategories.USABILITY.getName())) {
            return IsoCategory.Usability;
        }
        return null;
    }

    public static RulesCategory fromIsoCategory(IsoCategory iso) {
        if (iso == IsoCategory.Efficiency) {
            return Iso9126RulesCategories.EFFICIENCY;
        }
        if (iso == IsoCategory.Maintainability) {
            return Iso9126RulesCategories.MAINTAINABILITY;
        }
        if (iso == IsoCategory.Portability) {
            return Iso9126RulesCategories.PORTABILITY;
        }
        if (iso == IsoCategory.Reliability) {
            return Iso9126RulesCategories.RELIABILITY;
        }
        if (iso == IsoCategory.Usability) {
            return Iso9126RulesCategories.USABILITY;
        }
        return null;
    }
}

