/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRuleParamChange;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="active_rule_changes")
public class ActiveRuleChange
extends BaseIdentifiable {
    @Column(name="user_name", updatable=false, nullable=false)
    private String userName;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="profile_id", updatable=false, nullable=false)
    private RulesProfile rulesProfile;
    @Column(name="profile_version", updatable=false, nullable=false)
    private int profileVersion;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rule_id", updatable=false, nullable=false)
    private Rule rule;
    @Column(name="change_date", updatable=false, nullable=false)
    private Date date;
    @Column(name="enabled")
    private Boolean enabled;
    @Column(name="old_severity", updatable=false, nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private RulePriority oldSeverity;
    @Column(name="new_severity", updatable=false, nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private RulePriority newSeverity;
    @OneToMany(mappedBy="activeRuleChange", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ActiveRuleParamChange> activeRuleParamChanges = new ArrayList<ActiveRuleParamChange>();

    public ActiveRuleChange(String userName, RulesProfile profile, Rule rule) {
        this.userName = userName;
        this.rulesProfile = profile;
        this.profileVersion = profile.getVersion();
        this.rule = rule;
        this.date = Calendar.getInstance().getTime();
    }

    public Rule getRule() {
        return this.rule;
    }

    public RulePriority getOldSeverity() {
        return this.oldSeverity;
    }

    public void setOldSeverity(RulePriority oldSeverity) {
        this.oldSeverity = oldSeverity;
    }

    public RulePriority getNewSeverity() {
        return this.newSeverity;
    }

    public void setNewSeverity(RulePriority newSeverity) {
        this.newSeverity = newSeverity;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    public int getProfileVersion() {
        return this.profileVersion;
    }

    public String getRepositoryKey() {
        return this.rule.getRepositoryKey();
    }

    public String getConfigKey() {
        return this.rule.getConfigKey();
    }

    public String getRuleKey() {
        return this.rule.getKey();
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<ActiveRuleParamChange> getActiveRuleParamChanges() {
        return this.activeRuleParamChanges;
    }

    public String getUserName() {
        return this.userName;
    }

    public ActiveRuleChange setParameterChange(String key, String oldValue, String newValue) {
        RuleParam ruleParameter = this.rule.getParam(key);
        if (ruleParameter != null) {
            this.activeRuleParamChanges.add(new ActiveRuleParamChange(this, ruleParameter, oldValue, newValue));
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ActiveRuleChange rhs = (ActiveRuleChange)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.userName, (Object)rhs.userName).append((Object)this.rulesProfile, (Object)rhs.rulesProfile).append((Object)this.rule, (Object)rhs.rule).append((Object)this.date, (Object)rhs.date).append((Object)this.enabled, (Object)rhs.enabled).append((Object)this.newSeverity, (Object)rhs.newSeverity).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(41, 33).append((Object)this.userName).append((Object)this.rulesProfile).append((Object)this.rule).append((Object)this.date).append((Object)this.enabled).append((Object)this.newSeverity).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("profile", (Object)this.rulesProfile).append("rule", (Object)this.rule).append("modifier", (Object)this.userName).append("changed at", (Object)this.date).append("enabled", (Object)this.enabled).append("new severity", (Object)this.newSeverity).toString();
    }
}

