/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.database.model.MeasureModel;

@Entity
@Table(name="async_measure_snapshots")
public class AsyncMeasureSnapshot
extends BaseIdentifiable {
    @Column(name="project_measure_id", updatable=true, nullable=true)
    private Long measureId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="measure_date", updatable=true, nullable=true)
    private Date measureDate;
    @Column(name="snapshot_id", updatable=true, nullable=true)
    private Integer snapshotId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="snapshot_date", updatable=true, nullable=true)
    private Date snapshotDate;
    @Column(name="metric_id", updatable=true, nullable=true)
    private Integer metricId;
    @Column(name="project_id", updatable=true, nullable=true)
    private Integer projectId;

    public AsyncMeasureSnapshot(Long measureId, Integer snapshotId, Date measureDate, Date snapshotDate, Integer metricId, Integer projectId) {
        this.measureId = measureId;
        this.measureDate = measureDate;
        this.snapshotId = snapshotId;
        this.snapshotDate = snapshotDate;
        this.projectId = projectId;
        this.metricId = metricId;
    }

    public AsyncMeasureSnapshot() {
    }

    public Long getMeasureId() {
        return this.measureId;
    }

    public void setMeasureId(Long measureId) {
        this.measureId = measureId;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Integer snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Date getMeasureDate() {
        return this.measureDate;
    }

    public void setMeasureDate(Date measureDate) {
        this.measureDate = measureDate;
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public void setSnapshotDate(Date snapshotDate) {
        this.snapshotDate = snapshotDate;
    }

    public Integer getMetricId() {
        return this.metricId;
    }

    public void setMetricId(Integer metricId) {
        this.metricId = metricId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setMeasure(MeasureModel measure) {
        this.setMeasureId(measure.getId());
        this.setMeasureDate(measure.getMeasureDate());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AsyncMeasureSnapshot)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsyncMeasureSnapshot other = (AsyncMeasureSnapshot)obj;
        return new EqualsBuilder().append((Object)this.measureId, (Object)other.getMeasureId()).append((Object)this.measureDate, (Object)other.getMeasureDate()).append((Object)this.snapshotId, (Object)other.getSnapshotId()).append((Object)this.snapshotDate, (Object)other.getSnapshotDate()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.measureId).append((Object)this.measureDate).append((Object)this.snapshotDate).append((Object)this.snapshotId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("measureId", (Object)this.measureId).append("measureDate", (Object)this.measureDate).append("snapshotId", (Object)this.snapshotId).append("snapshotDate", (Object)this.snapshotDate).toString();
    }
}

