/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.mavenplugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.sonar:sonar-packaging-maven-plugin:1.6.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Sonar :: Update Center :: Packaging Mojo", 0);
        this.append(sb, "Sonar Update Center", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check-dependencies".equals(this.goal)) {
            this.append(sb, "sonar-packaging:check-dependencies", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "appDirectory", 2);
                this.append(sb, "The directory where the app is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "basePlugin", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "Directory containing the classes and resource files that should be packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "Name of the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory containing the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginClass", 2);
                this.append(sb, "Name of plugin class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginDescription (Default: ${project.description})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginIssueTrackerUrl (Default: ${project.issueManagement.url})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginKey", 2);
                this.append(sb, "Plugin key.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginName (Default: ${project.name})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginParent", 2);
                this.append(sb, "Plugin parent.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginTermsConditionsUrl", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginUrl (Default: ${project.url})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "requirePlugins", 2);
                this.append(sb, "Plugin's dependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipDependenciesPackaging", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "useChildFirstClassLoader", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "sonar-packaging:help", 0);
            this.append(sb, "Display help information on sonar-packaging-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0sonar-packaging:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sonar-plugin".equals(this.goal)) {
            this.append(sb, "sonar-packaging:sonar-plugin", 0);
            this.append(sb, "Build a Sonar Plugin from the current project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMavenDescriptor", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "appDirectory", 2);
                this.append(sb, "The directory where the app is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "basePlugin", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "Directory containing the classes and resource files that should be packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "Name of the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory containing the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginClass", 2);
                this.append(sb, "Name of plugin class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginDescription (Default: ${project.description})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginIssueTrackerUrl (Default: ${project.issueManagement.url})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginKey", 2);
                this.append(sb, "Plugin key.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginName (Default: ${project.name})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginParent", 2);
                this.append(sb, "Plugin parent.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginTermsConditionsUrl", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginUrl (Default: ${project.url})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "requirePlugins", 2);
                this.append(sb, "Plugin's dependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipDependenciesPackaging", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "useChildFirstClassLoader", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

