/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.mavenplugin;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractSonarPluginMojo
extends AbstractMojo {
    public static final String SONAR_GROUPID = "org.codehaus.sonar";
    public static final String SONAR_PLUGIN_API_ARTIFACTID = "sonar-plugin-api";
    public static final String SONAR_PLUGIN_API_TYPE = "jar";
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Parameter(property="project.build.directory", required=true)
    private File outputDirectory;
    @Parameter(property="project.build.outputDirectory", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File appDirectory;
    @Parameter(alias="jarName", property="project.build.finalName", required=true)
    private String finalName;
    @Parameter
    private String classifier;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="sonar.pluginKey")
    protected String pluginKey;
    @Parameter(property="sonar.pluginTermsConditionsUrl")
    private String pluginTermsConditionsUrl;
    @Parameter(property="sonar.pluginClass", required=true)
    private String pluginClass;
    @Parameter(property="sonar.pluginName", required=true, defaultValue="${project.name}")
    private String pluginName;
    @Parameter(property="sonar.pluginParent")
    protected String pluginParent;
    @Parameter(property="sonar.requirePlugins")
    protected String requirePlugins;
    @Parameter(property="sonar.pluginDescription", defaultValue="${project.description}")
    private String pluginDescription;
    @Parameter(property="sonar.pluginUrl", defaultValue="${project.url}")
    private String pluginUrl;
    @Parameter(defaultValue="${project.issueManagement.url}")
    private String pluginIssueTrackerUrl;
    @Parameter
    private boolean useChildFirstClassLoader = false;
    @Parameter
    private String basePlugin;
    @Parameter(property="sonar.skipDependenciesPackaging")
    private boolean skipDependenciesPackaging = false;

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final MavenSession getSession() {
        return this.session;
    }

    protected final File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected final File getClassesDirectory() {
        return this.classesDirectory;
    }

    public File getAppDirectory() {
        return this.appDirectory;
    }

    protected final String getFinalName() {
        return this.finalName;
    }

    protected final String getClassifier() {
        return this.classifier;
    }

    public String getExplicitPluginKey() {
        return this.pluginKey;
    }

    protected final String getPluginClass() {
        return this.pluginClass;
    }

    protected final String getPluginName() {
        return this.pluginName;
    }

    protected final String getPluginParent() {
        return this.pluginParent;
    }

    protected final String getRequirePlugins() {
        return this.requirePlugins;
    }

    protected final String getPluginDescription() {
        return this.pluginDescription;
    }

    protected final String getPluginUrl() {
        return this.pluginUrl;
    }

    protected String getPluginTermsConditionsUrl() {
        return this.pluginTermsConditionsUrl;
    }

    protected String getPluginIssueTrackerUrl() {
        return this.pluginIssueTrackerUrl;
    }

    public boolean isUseChildFirstClassLoader() {
        return this.useChildFirstClassLoader;
    }

    public String getBasePlugin() {
        return this.basePlugin;
    }

    protected boolean isSkipDependenciesPackaging() {
        return this.skipDependenciesPackaging;
    }

    protected Set<Artifact> getDependencyArtifacts() {
        return this.getProject().getDependencyArtifacts();
    }

    protected Set<Artifact> getDependencyArtifacts(String scope) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact dep : this.getDependencyArtifacts()) {
            if (!scope.equals(dep.getScope())) continue;
            result.add(dep);
        }
        return result;
    }

    protected Set<Artifact> getIncludedArtifacts() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Set artifacts = this.getProject().getArtifacts();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    protected final Artifact getSonarPluginApiArtifact() {
        Set<Artifact> dependencies = this.getDependencyArtifacts();
        if (dependencies != null) {
            for (Artifact dep : dependencies) {
                if (!SONAR_GROUPID.equals(dep.getGroupId()) || !SONAR_PLUGIN_API_ARTIFACTID.equals(dep.getArtifactId()) || !SONAR_PLUGIN_API_TYPE.equals(dep.getType())) continue;
                return dep;
            }
        }
        return null;
    }

    protected String getMessage(String title, List<String> ids) {
        StringBuilder message = new StringBuilder();
        message.append(title);
        message.append("\n\n");
        for (String id : ids) {
            message.append("\t").append(id).append("\n");
        }
        return message.toString();
    }
}

