/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.mavenplugin;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.PluginKeyUtils;
import org.sonar.updatecenter.mavenplugin.AbstractSonarPluginMojo;

public class SonarPluginMojo
extends AbstractSonarPluginMojo {
    private static final String LIB_DIR = "META-INF/lib/";
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    protected JarArchiver jarArchiver;
    private String[] includes;
    private String[] excludes;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private boolean addMavenDescriptor = true;

    protected static File getJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (StringUtils.isNotBlank((String)classifier) && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkMandatoryAttributes();
        File jarFile = this.createArchive();
        String classifier = this.getClassifier();
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "jar", classifier, jarFile);
        } else {
            this.getProject().getArtifact().setFile(jarFile);
        }
    }

    private void checkMandatoryAttributes() throws MojoExecutionException {
        this.checkPluginName();
        this.checkPluginDescription();
        this.checkPluginKey();
        this.checkPluginClass();
    }

    private void checkPluginClass() throws MojoExecutionException {
        if (!new File(this.getClassesDirectory(), this.getPluginClass().replace('.', '/') + ".class").exists()) {
            throw new MojoExecutionException("Plugin class not found: '" + this.getPluginClass());
        }
    }

    private void checkPluginKey() throws MojoExecutionException {
        if (StringUtils.isNotBlank((String)this.getExplicitPluginKey()) && !PluginKeyUtils.isValid((String)this.getExplicitPluginKey())) {
            throw new MojoExecutionException("Plugin key is badly formatted. Please use ascii letters and digits only: " + this.getExplicitPluginKey());
        }
    }

    private void checkPluginDescription() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.getPluginDescription())) {
            throw new MojoExecutionException("Plugin description is missing. Please add the field <description> or the property sonar.pluginDescription.");
        }
    }

    private void checkPluginName() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.getPluginName()) || this.getPluginName().startsWith("Unnamed - ")) {
            throw new MojoExecutionException("Plugin name is missing. Please add the field <name> or the property sonar.pluginName.");
        }
    }

    public File createArchive() throws MojoExecutionException {
        File jarFile = SonarPluginMojo.getJarFile(this.getOutputDirectory(), this.getFinalName(), this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        try {
            archiver.getArchiver().addDirectory(this.getClassesDirectory(), this.getIncludes(), this.getExcludes());
            this.archive.setAddMavenDescriptor(this.addMavenDescriptor);
            String logLine = "-------------------------------------------------------";
            this.getLog().info((CharSequence)logLine);
            this.getLog().info((CharSequence)"Plugin definition in update center");
            this.addManifestProperty("Key", "Plugin-Key", this.getPluginKey());
            this.addManifestProperty("Name", "Plugin-Name", this.getPluginName());
            this.addManifestProperty("Description", "Plugin-Description", this.getPluginDescription());
            this.addManifestProperty("Version", "Plugin-Version", this.getProject().getVersion());
            this.addManifestProperty("Main class", "Plugin-Class", this.getPluginClass());
            if (this.getPluginParent() != null) {
                this.addManifestProperty("Parent", "Plugin-Parent", this.getPluginParent());
            }
            if (this.getRequirePlugins() != null) {
                this.addManifestProperty("Require plugins", "Plugin-RequirePlugins", this.getRequirePlugins());
            }
            if (this.isUseChildFirstClassLoader()) {
                this.getLog().info((CharSequence)"    Uses child-first class loading strategy");
                this.archive.addManifestEntry((Object)"Plugin-ChildFirstClassLoader", (Object)"true");
            }
            if (StringUtils.isNotBlank((String)this.getBasePlugin())) {
                this.getLog().info((CharSequence)("    Base plugin: " + this.getBasePlugin()));
                this.archive.addManifestEntry((Object)"Plugin-Base", (Object)this.getBasePlugin());
            }
            this.addManifestProperty("Homepage", "Plugin-Homepage", this.getPluginUrl());
            this.addManifestProperty("Sonar version", "Sonar-Version", this.getSonarPluginApiArtifact().getVersion());
            this.addManifestProperty("License", "Plugin-License", this.getPluginLicense());
            this.addManifestProperty("Organization", "Plugin-Organization", this.getPluginOrganization());
            this.addManifestProperty("Organization URL", "Plugin-OrganizationUrl", this.getPluginOrganizationUrl());
            this.addManifestProperty("Terms & Conditions URL", "Plugin-TermsConditionsUrl", this.getPluginTermsConditionsUrl());
            this.addManifestProperty("Issue Tracker URL", "Plugin-IssueTrackerUrl", this.getPluginIssueTrackerUrl());
            this.addManifestProperty("Build date", "Plugin-BuildDate", FormatUtils.toString((Date)new Date(), (boolean)true));
            this.addManifestProperty("Sources URL", "Plugin-SourcesUrl", this.getSourcesUrl());
            this.addManifestProperty("Developers", "Plugin-Developers", this.getDevelopers());
            this.getLog().info((CharSequence)logLine);
            if (this.isSkipDependenciesPackaging()) {
                this.getLog().info((CharSequence)"Skip packaging of dependencies");
            } else {
                List<String> libs = this.copyDependencies();
                if (!libs.isEmpty()) {
                    archiver.getArchiver().addDirectory(this.getAppDirectory(), this.getIncludes(), this.getExcludes());
                    this.archive.addManifestEntry((Object)"Plugin-Dependencies", (Object)StringUtils.join(libs, (String)" "));
                }
            }
            this.checkParentAndRequiresPluginProperties();
            archiver.createArchive(this.getProject(), this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling Sonar-plugin: " + e.getMessage(), e);
        }
    }

    private void checkParentAndRequiresPluginProperties() {
        if (this.getPluginParent() != null && this.getRequirePlugins() != null) {
            throw new IllegalStateException(String.format("The plugin '%s' can't be both part of the plugin '%s' and having a dependency on '%s'", this.getPluginKey(), this.getPluginParent(), this.getRequirePlugins()));
        }
        if (this.getPluginParent() != null && this.getPluginParent().equals(this.getPluginKey())) {
            throw new IllegalStateException(String.format("The plugin '%s' can't be his own parent. Please remove the '%s' property.", this.getPluginKey(), "Plugin-Parent"));
        }
    }

    private void addManifestProperty(String label, String key, String value) {
        this.getLog().info((CharSequence)("    " + label + ": " + StringUtils.defaultString((String)value)));
        this.archive.addManifestEntry((Object)key, (Object)value);
    }

    private String getPluginLicense() {
        ArrayList<String> licenses = new ArrayList<String>();
        if (this.getProject().getLicenses() != null) {
            for (Object license : this.getProject().getLicenses()) {
                License l = (License)license;
                if (l.getName() == null) continue;
                licenses.add(l.getName());
            }
        }
        return StringUtils.join(licenses, (String)" ");
    }

    private String getPluginOrganization() {
        if (this.getProject().getOrganization() != null) {
            return this.getProject().getOrganization().getName();
        }
        return null;
    }

    private String getPluginOrganizationUrl() {
        if (this.getProject().getOrganization() != null) {
            return this.getProject().getOrganization().getUrl();
        }
        return null;
    }

    private String getPluginKey() {
        if (StringUtils.isNotBlank((String)this.getExplicitPluginKey())) {
            return this.getExplicitPluginKey();
        }
        return PluginKeyUtils.sanitize((String)this.getProject().getArtifactId());
    }

    private String getSourcesUrl() {
        if (this.getProject().getScm() != null) {
            return this.getProject().getScm().getUrl();
        }
        return null;
    }

    private String getDevelopers() {
        if (this.getProject().getDevelopers() != null) {
            return Joiner.on((String)",").join(Iterables.transform((Iterable)this.getProject().getDevelopers(), (Function)new Function<Developer, String>(){

                public String apply(Developer developer) {
                    return developer.getName();
                }
            }));
        }
        return null;
    }

    private List<String> copyDependencies() throws IOException, DependencyTreeBuilderException {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> libs = new ArrayList<String>();
        File libDirectory = new File(this.getAppDirectory(), LIB_DIR);
        Set<Artifact> artifacts = this.getNotProvidedDependencies();
        for (Artifact artifact : artifacts) {
            String targetFileName = this.getDefaultFinalName(artifact);
            FileUtils.copyFileIfModified((File)artifact.getFile(), (File)new File(libDirectory, targetFileName));
            libs.add(LIB_DIR + targetFileName);
            ids.add(artifact.getDependencyConflictId());
        }
        if (!ids.isEmpty()) {
            this.getLog().info((CharSequence)this.getMessage("Following dependencies are packaged in the plugin:", ids));
            this.getLog().info((CharSequence)("See following page for more details about plugin dependencies:\n" + "\n\thttp://docs.codehaus.org/display/SONAR/Coding+a+plugin\n"));
        }
        return libs;
    }

    private String getDefaultFinalName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
    }

    private Set<Artifact> getNotProvidedDependencies() throws DependencyTreeBuilderException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Set<Artifact> providedArtifacts = this.getSonarProvidedArtifacts();
        for (Artifact artifact : this.getIncludedArtifacts()) {
            if (this.isSonarPlugin(artifact) || this.isScopeProvidedOrTest(artifact) || this.containsArtifact(providedArtifacts, artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    private boolean isScopeProvidedOrTest(Artifact artifact) {
        return "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope());
    }

    private boolean isSonarPlugin(Artifact artifact) {
        return "sonar-plugin".equals(artifact.getType());
    }

    private boolean containsArtifact(Set<Artifact> artifacts, Artifact artifact) {
        for (Artifact a : artifacts) {
            if (!StringUtils.equals((String)a.getGroupId(), (String)artifact.getGroupId()) || !StringUtils.equals((String)a.getArtifactId(), (String)artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private Set<Artifact> getSonarProvidedArtifacts() throws DependencyTreeBuilderException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("runtime");
        DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyTree(this.getProject(), this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
        rootNode.accept((DependencyNodeVisitor)new BuildingDependencyNodeVisitor());
        this.searchForSonarProvidedArtifacts(rootNode, result, false);
        return result;
    }

    private void searchForSonarProvidedArtifacts(DependencyNode dependency, Set<Artifact> sonarArtifacts, boolean isProvidedBySonar) {
        if (dependency != null) {
            if (dependency.getParent() != null) {
                boolean bl = isProvidedBySonar = isProvidedBySonar || "org.codehaus.sonar".equals(dependency.getArtifact().getGroupId()) && !"test".equals(dependency.getArtifact().getScope());
            }
            if (isProvidedBySonar) {
                sonarArtifacts.add(dependency.getArtifact());
            }
            if (!"test".equals(dependency.getArtifact().getScope())) {
                for (Object childDep : dependency.getChildren()) {
                    this.searchForSonarProvidedArtifacts((DependencyNode)childDep, sonarArtifacts, isProvidedBySonar);
                }
            }
        }
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

