/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonar.graph.Cycle;
import org.sonar.graph.CycleDetector;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.Edge;
import org.sonar.graph.MinimumFeedbackEdgeSetSolver;

public class IncrementalCyclesAndFESSolver<V> {
    private Set<Cycle> cycles = new HashSet<Cycle>();
    private long searchCyclesCalls = 0L;
    private static final int DEFAULT_MAX_SEARCH_DEPTH_AT_FIRST = 3;
    private static final int DEFAULT_MAX_CYCLES_TO_FOUND_BY_ITERATION = 100;
    private MinimumFeedbackEdgeSetSolver solver;
    private int iterations = 0;

    public IncrementalCyclesAndFESSolver(DirectedGraphAccessor<V, ? extends Edge> graph, Collection<V> vertices) {
        this(graph, vertices, 3, 100);
    }

    public IncrementalCyclesAndFESSolver(DirectedGraphAccessor<V, ? extends Edge> graph, Collection<V> vertices, int maxSearchDepthAtFirst, int maxCyclesToFoundByIteration) {
        ++this.iterations;
        CycleDetector<V> cycleDetector = new CycleDetector<V>(graph, vertices);
        cycleDetector.detectCyclesWithMaxSearchDepth(maxSearchDepthAtFirst);
        this.searchCyclesCalls += cycleDetector.getSearchCyclesCalls();
        this.cycles.addAll(cycleDetector.getCycles());
        this.solver = new MinimumFeedbackEdgeSetSolver(this.cycles);
        Set<Edge> edgesToExclude = this.solver.getEdges();
        do {
            ++this.iterations;
            cycleDetector = new CycleDetector<V>(graph, vertices, edgesToExclude);
            cycleDetector.detectCyclesWithUpperLimit(maxCyclesToFoundByIteration);
            this.searchCyclesCalls += cycleDetector.getSearchCyclesCalls();
            this.cycles.addAll(cycleDetector.getCycles());
            this.solver = new MinimumFeedbackEdgeSetSolver(this.cycles);
            edgesToExclude = this.solver.getEdges();
        } while (!cycleDetector.getCycles().isEmpty());
    }

    public int getWeightOfFeedbackEdgeSet() {
        return this.solver.getWeightOfFeedbackEdgeSet();
    }

    public int getNumberOfLoops() {
        return this.solver.getNumberOfLoops();
    }

    public Set<Edge> getFeedbackEdgeSet() {
        return this.solver.getEdges();
    }

    public Set<Cycle> getCycles() {
        return this.cycles;
    }

    public boolean isAcyclicGraph() {
        return this.cycles.isEmpty();
    }

    public long getSearchCyclesCalls() {
        return this.searchCyclesCalls;
    }

    public int getIterations() {
        return this.iterations;
    }
}

