/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.DsmCell;
import org.sonar.graph.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dsm<V> {
    private V[] vertices;
    private DsmCell[][] cells;
    private int dimension;
    private DirectedGraphAccessor<V, ? extends Edge<V>> graph;

    public Dsm(DirectedGraphAccessor<V, ? extends Edge<V>> graph, Collection<V> vertices, Set<Edge> feedbackEdges) {
        this.graph = graph;
        this.dimension = vertices.size();
        this.cells = new DsmCell[this.dimension][this.dimension];
        this.initVertices(vertices);
        this.initCells(feedbackEdges);
    }

    public Dsm(DirectedGraphAccessor<V, ? extends Edge<V>> acyclicGraph, Set<Edge> feedbackEdges) {
        this(acyclicGraph, acyclicGraph.getVertices(), feedbackEdges);
    }

    public Dsm(DirectedGraphAccessor<V, ? extends Edge<V>> acyclicGraph) {
        this(acyclicGraph, acyclicGraph.getVertices(), Collections.emptySet());
    }

    private void initCells(Set<Edge> feedbackEdges) {
        for (int x = 0; x < this.dimension; ++x) {
            for (int y = 0; y < this.dimension; ++y) {
                DsmCell cell;
                V from = this.vertices[x];
                V to = this.vertices[y];
                Edge<V> edge = this.graph.getEdge(from, to);
                boolean isFeedbackEdge = edge != null && feedbackEdges.contains(edge);
                this.cells[x][y] = cell = new DsmCell(edge, isFeedbackEdge);
            }
        }
    }

    private void initVertices(Collection<V> verticesCol) {
        this.vertices = new Object[this.dimension];
        int i = 0;
        for (V vertex : verticesCol) {
            this.vertices[i] = vertex;
            ++i;
        }
    }

    public V getVertex(int rowIndex) {
        return this.vertices[rowIndex];
    }

    public int getDimension() {
        return this.dimension;
    }

    public void permute(int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            this.checkIndicesBoudaries(fromIndex, toIndex);
            this.permuteVertice(fromIndex, toIndex);
            this.permuteColumns(fromIndex, toIndex);
            this.permuteRows(fromIndex, toIndex);
        }
    }

    private void checkIndicesBoudaries(int ... indices) {
        for (int index : indices) {
            if (index >= 0 && index < this.dimension) continue;
            StringBuilder builder = new StringBuilder("DSM contains the following vertices : ");
            for (V vertex : this.vertices) {
                builder.append(vertex.toString()).append(" | ");
            }
            builder.append(". Trying to reach index ").append(index);
            throw new ArrayIndexOutOfBoundsException(builder.toString());
        }
    }

    private void permuteVertice(int fromIndex, int toIndex) {
        V toVertex;
        V fromVertex = this.vertices[fromIndex];
        this.vertices[fromIndex] = toVertex = this.vertices[toIndex];
        this.vertices[toIndex] = fromVertex;
    }

    private void permuteRows(int fromYIndex, int toYIndex) {
        for (int x = 0; x < this.dimension; ++x) {
            this.permuteCells(x, fromYIndex, x, toYIndex);
        }
    }

    private void permuteColumns(int fromXIndex, int toXIndex) {
        for (int y = 0; y < this.dimension; ++y) {
            this.permuteCells(fromXIndex, y, toXIndex, y);
        }
    }

    private void permuteCells(int fromXIndex, int fromYIndex, int toXIndex, int toYIndex) {
        DsmCell fromCell = this.cells[fromXIndex][fromYIndex];
        DsmCell toCell = this.cells[toXIndex][toYIndex];
        this.cells[toXIndex][toYIndex] = fromCell;
        this.cells[fromXIndex][fromYIndex] = toCell;
    }

    public int getNumberOfIncomingEdges(int y, int from, int to) {
        int incomingEdges = 0;
        for (int x = from; x <= to; ++x) {
            DsmCell cell = this.cells[x][y];
            if (cell.getWeight() == 0 || cell.isFeedbackEdge()) continue;
            ++incomingEdges;
        }
        return incomingEdges;
    }

    public int getNumberOfOutgoingEdges(int x, int from, int to) {
        int outgoingEdges = 0;
        for (int y = from; y <= to; ++y) {
            DsmCell cell = this.cells[x][y];
            if (cell.getWeight() == 0 || cell.isFeedbackEdge()) continue;
            ++outgoingEdges;
        }
        return outgoingEdges;
    }

    public DsmCell getCell(int x, int y) {
        return this.cells[x][y];
    }

    public V[] getVertices() {
        Object[] verticesCopy = new Object[this.vertices.length];
        System.arraycopy(this.vertices, 0, verticesCopy, 0, this.vertices.length);
        return verticesCopy;
    }
}

