/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.AbstractCloneIndex;
import org.sonar.duplications.index.DataUtils;
import org.sonar.duplications.utils.FastStringComparator;

public class PackedMemoryCloneIndex
extends AbstractCloneIndex {
    private static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private static final int BLOCK_INTS = 5;
    private final int hashInts;
    private final int blockInts;
    private boolean sorted = false;
    private int size;
    private String[] resourceIds;
    private int[] blockData;
    private int[] resourceIdsIndex;
    private final Block.Builder blockBuilder = Block.builder();
    private final DataUtils.Sortable byBlockHash = new DataUtils.Sortable(){

        @Override
        public void swap(int i, int j) {
            String tmp = PackedMemoryCloneIndex.this.resourceIds[i];
            ((PackedMemoryCloneIndex)PackedMemoryCloneIndex.this).resourceIds[i] = PackedMemoryCloneIndex.this.resourceIds[j];
            ((PackedMemoryCloneIndex)PackedMemoryCloneIndex.this).resourceIds[j] = tmp;
            i *= PackedMemoryCloneIndex.this.blockInts;
            j *= PackedMemoryCloneIndex.this.blockInts;
            int k = 0;
            while (k < PackedMemoryCloneIndex.this.blockInts) {
                int x = PackedMemoryCloneIndex.this.blockData[i];
                ((PackedMemoryCloneIndex)PackedMemoryCloneIndex.this).blockData[i] = PackedMemoryCloneIndex.this.blockData[j];
                ((PackedMemoryCloneIndex)PackedMemoryCloneIndex.this).blockData[j] = x;
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public boolean isLess(int i, int j) {
            return PackedMemoryCloneIndex.this.isLessByHash(i, j);
        }

        @Override
        public int size() {
            return PackedMemoryCloneIndex.this.size;
        }
    };
    private final DataUtils.Sortable byResourceId = new DataUtils.Sortable(){

        @Override
        public void swap(int i, int j) {
            int tmp = PackedMemoryCloneIndex.this.resourceIdsIndex[i];
            ((PackedMemoryCloneIndex)PackedMemoryCloneIndex.this).resourceIdsIndex[i] = PackedMemoryCloneIndex.this.resourceIdsIndex[j];
            ((PackedMemoryCloneIndex)PackedMemoryCloneIndex.this).resourceIdsIndex[j] = tmp;
        }

        @Override
        public boolean isLess(int i, int j) {
            String s2;
            String s1 = PackedMemoryCloneIndex.this.resourceIds[PackedMemoryCloneIndex.this.resourceIdsIndex[i]];
            return FastStringComparator.INSTANCE.compare(s1, s2 = PackedMemoryCloneIndex.this.resourceIds[PackedMemoryCloneIndex.this.resourceIdsIndex[j]]) < 0;
        }

        @Override
        public int size() {
            return PackedMemoryCloneIndex.this.size;
        }
    };

    public PackedMemoryCloneIndex() {
        this(8, 1024);
    }

    public PackedMemoryCloneIndex(int hashBytes, int initialCapacity) {
        this.hashInts = hashBytes / 4;
        this.blockInts = this.hashInts + 5;
        this.size = 0;
        this.resourceIds = new String[initialCapacity];
        this.blockData = new int[initialCapacity * this.blockInts];
        this.resourceIdsIndex = new int[initialCapacity];
    }

    @Override
    public Collection<Block> getByResourceId(String resourceId) {
        this.ensureSorted();
        this.resourceIds[this.size] = resourceId;
        this.resourceIdsIndex[this.size] = this.size;
        int index = DataUtils.binarySearch(this.byResourceId);
        ArrayList result = Lists.newArrayList();
        int realIndex = this.resourceIdsIndex[index];
        while (index < this.size && FastStringComparator.INSTANCE.compare(this.resourceIds[realIndex], resourceId) == 0) {
            int offset = realIndex * this.blockInts;
            int[] hash = new int[this.hashInts];
            for (int j = 0; j < this.hashInts; ++j) {
                hash[j] = this.blockData[offset++];
            }
            int indexInFile = this.blockData[offset++];
            int firstLineNumber = this.blockData[offset++];
            int lastLineNumber = this.blockData[offset++];
            int startUnit = this.blockData[offset++];
            int endUnit = this.blockData[offset];
            Block block = this.blockBuilder.setResourceId(resourceId).setBlockHash(new ByteArray(hash)).setIndexInFile(indexInFile).setLines(firstLineNumber, lastLineNumber).setUnit(startUnit, endUnit).build();
            result.add(block);
            realIndex = this.resourceIdsIndex[++index];
        }
        return result;
    }

    @Override
    public Collection<Block> getBySequenceHash(ByteArray sequenceHash) {
        this.ensureSorted();
        int[] hash = sequenceHash.toIntArray();
        if (hash.length != this.hashInts) {
            throw new IllegalArgumentException("Expected " + this.hashInts + " ints in hash, but got " + hash.length);
        }
        int offset = this.size * this.blockInts;
        for (int i = 0; i < this.hashInts; ++i) {
            this.blockData[offset++] = hash[i];
        }
        ArrayList result = Lists.newArrayList();
        for (int index = DataUtils.binarySearch(this.byBlockHash); index < this.size && !this.isLessByHash(this.size, index); ++index) {
            String resourceId = this.resourceIds[index];
            offset = index * this.blockInts + this.hashInts;
            int indexInFile = this.blockData[offset++];
            int firstLineNumber = this.blockData[offset++];
            int lastLineNumber = this.blockData[offset++];
            int startUnit = this.blockData[offset++];
            int endUnit = this.blockData[offset];
            Block block = this.blockBuilder.setResourceId(resourceId).setBlockHash(sequenceHash).setIndexInFile(indexInFile).setLines(firstLineNumber, lastLineNumber).setUnit(startUnit, endUnit).build();
            result.add(block);
        }
        return result;
    }

    @Override
    public void insert(Block block) {
        this.sorted = false;
        this.ensureCapacity();
        this.resourceIds[this.size] = block.getResourceId();
        int[] hash = block.getBlockHash().toIntArray();
        if (hash.length != this.hashInts) {
            throw new IllegalArgumentException("Expected " + this.hashInts + " ints in hash, but got " + hash.length);
        }
        int offset = this.size * this.blockInts;
        for (int i = 0; i < this.hashInts; ++i) {
            this.blockData[offset++] = hash[i];
        }
        this.blockData[offset++] = block.getIndexInFile();
        this.blockData[offset++] = block.getStartLine();
        this.blockData[offset++] = block.getEndLine();
        this.blockData[offset++] = block.getStartUnit();
        this.blockData[offset] = block.getEndUnit();
        ++this.size;
    }

    private void ensureCapacity() {
        if (this.size < this.resourceIds.length) {
            return;
        }
        int newCapacity = this.resourceIds.length * 3 / 2 + 1;
        String[] oldResourceIds = this.resourceIds;
        this.resourceIds = new String[newCapacity];
        System.arraycopy(oldResourceIds, 0, this.resourceIds, 0, oldResourceIds.length);
        int[] oldBlockData = this.blockData;
        this.blockData = new int[newCapacity * this.blockInts];
        System.arraycopy(oldBlockData, 0, this.blockData, 0, oldBlockData.length);
        this.resourceIdsIndex = new int[newCapacity];
        this.sorted = false;
    }

    private void ensureSorted() {
        if (this.sorted) {
            return;
        }
        this.ensureCapacity();
        DataUtils.sort(this.byBlockHash);
        for (int i = 0; i < this.size; ++i) {
            this.resourceIdsIndex[i] = i;
        }
        DataUtils.sort(this.byResourceId);
        this.sorted = true;
    }

    private boolean isLessByHash(int i, int j) {
        int i2 = i * this.blockInts;
        int j2 = j * this.blockInts;
        int k = 0;
        while (k < this.hashInts) {
            if (this.blockData[i2] < this.blockData[j2]) {
                return true;
            }
            if (this.blockData[i2] > this.blockData[j2]) {
                return false;
            }
            ++k;
            ++i2;
            ++j2;
        }
        return false;
    }
}

