/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.sonar.duplications.index.CloneGroup;

@Beta
public final class DuplicationPredicates {
    private DuplicationPredicates() {
    }

    public static Predicate<CloneGroup> numberOfUnitsNotLessThan(int min) {
        return new NumberOfUnitsNotLessThan(min);
    }

    private static class NumberOfUnitsNotLessThan
    implements Predicate<CloneGroup> {
        private final int min;

        public NumberOfUnitsNotLessThan(int min) {
            this.min = min;
        }

        public boolean apply(@Nullable CloneGroup input) {
            return input != null && input.getLengthInUnits() >= this.min;
        }
    }
}

