/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.duplications.detector.suffixtree.Edge;
import org.sonar.duplications.detector.suffixtree.SuffixTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Node {
    private final SuffixTree suffixTree;
    private final Map<Object, Edge> edges;
    private Node suffixNode;
    int depth;
    int startSize;
    int endSize;

    public Node(Node node, Node suffixNode) {
        this(node.suffixTree, suffixNode);
    }

    public Node(SuffixTree suffixTree, Node suffixNode) {
        this.suffixTree = suffixTree;
        this.suffixNode = suffixNode;
        this.edges = new HashMap<Object, Edge>();
    }

    public Object symbolAt(int index) {
        return this.suffixTree.symbolAt(index);
    }

    public void addEdge(int charIndex, Edge edge) {
        this.edges.put(this.symbolAt(charIndex), edge);
    }

    public void removeEdge(int charIndex) {
        this.edges.remove(this.symbolAt(charIndex));
    }

    public Edge findEdge(Object ch) {
        return this.edges.get(ch);
    }

    public Node getSuffixNode() {
        return this.suffixNode;
    }

    public void setSuffixNode(Node suffixNode) {
        this.suffixNode = suffixNode;
    }

    public Collection<Edge> getEdges() {
        return this.edges.values();
    }
}

