/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import org.sonar.duplications.index.CloneGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class DuplicationPredicates {
    private DuplicationPredicates() {
    }

    public static Predicate<CloneGroup> numberOfUnitsNotLessThan(int min) {
        return new NumberOfUnitsNotLessThan(min);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberOfUnitsNotLessThan
    implements Predicate<CloneGroup> {
        private final int min;

        public NumberOfUnitsNotLessThan(int min) {
            this.min = min;
        }

        public boolean apply(CloneGroup input) {
            return input.getLengthInUnits() >= this.min;
        }
    }
}

