/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.JavaPackage;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.WildcardPattern;

@Deprecated
public class JavaFile
extends Resource {
    private static final String JAVA_SUFFIX = ".java";
    private static final String JAV_SUFFIX = ".jav";
    private String className;
    private String filename;
    private String fullyQualifiedName;
    private String packageFullyQualifiedName;
    private boolean unitTest;
    private JavaPackage parent;

    private JavaFile() {
    }

    public JavaFile(String packageName, String className) {
        this(packageName, className, false);
    }

    public JavaFile(String packageKey, String className, boolean unitTest) {
        String deprecatedKey;
        if (className == null) {
            throw new IllegalArgumentException("Java filename can not be null");
        }
        this.className = StringUtils.trim((String)className);
        if (StringUtils.isBlank((String)packageKey)) {
            this.packageFullyQualifiedName = "[default]";
            this.fullyQualifiedName = this.className;
            deprecatedKey = this.packageFullyQualifiedName + "." + this.className;
        } else {
            this.packageFullyQualifiedName = packageKey.trim();
            this.fullyQualifiedName = deprecatedKey = this.packageFullyQualifiedName + "." + this.className;
        }
        this.setDeprecatedKey(deprecatedKey);
        this.unitTest = unitTest;
    }

    public JavaFile(String deprecatedKey) {
        this(deprecatedKey, false);
    }

    public JavaFile(String deprecatedKey, boolean unitTest) {
        if (deprecatedKey == null) {
            throw new IllegalArgumentException("Java filename can not be null");
        }
        String realKey = StringUtils.trim((String)deprecatedKey);
        this.unitTest = unitTest;
        if (realKey.contains(".")) {
            this.className = StringUtils.substringAfterLast((String)realKey, (String)".");
            this.packageFullyQualifiedName = StringUtils.substringBeforeLast((String)realKey, (String)".");
            this.fullyQualifiedName = realKey;
        } else {
            this.className = realKey;
            this.fullyQualifiedName = realKey;
            this.packageFullyQualifiedName = "[default]";
            realKey = "[default]" + "." + realKey;
        }
        this.setDeprecatedKey(realKey);
    }

    public JavaPackage getParent() {
        if (this.parent == null) {
            this.parent = new JavaPackage(this.packageFullyQualifiedName);
        }
        return this.parent;
    }

    public String getDescription() {
        return null;
    }

    public Language getLanguage() {
        return Java.INSTANCE;
    }

    public String getName() {
        return StringUtils.isNotBlank((String)this.filename) ? this.filename : this.className + JAVA_SUFFIX;
    }

    public String getLongName() {
        return this.fullyQualifiedName;
    }

    public String getScope() {
        return "FIL";
    }

    public String getQualifier() {
        return this.unitTest ? "UTS" : "FIL";
    }

    public boolean isUnitTest() {
        return this.unitTest;
    }

    public boolean matchFilePattern(String antPattern) {
        WildcardPattern matcher = WildcardPattern.create((String)antPattern, (String)"/");
        return matcher.match(this.getKey());
    }

    public static JavaFile fromIOFile(File file, Project module, boolean unitTest) {
        if (file == null || !StringUtils.endsWithIgnoreCase((String)file.getName(), (String)JAVA_SUFFIX)) {
            return null;
        }
        PathResolver.RelativePath relativePath = new PathResolver().relativePath((Collection)(unitTest ? module.getFileSystem().getTestDirs() : module.getFileSystem().getSourceDirs()), file);
        if (relativePath != null) {
            JavaFile sonarFile = JavaFile.fromRelativePath(relativePath.path(), unitTest);
            sonarFile.setPath(new PathResolver().relativePath(module.getFileSystem().getBasedir(), file));
            return sonarFile;
        }
        return null;
    }

    public static JavaFile create(String relativePathFromBasedir) {
        JavaFile javaFile = new JavaFile();
        String normalizedPath = JavaFile.normalize((String)relativePathFromBasedir);
        javaFile.setKey(normalizedPath);
        javaFile.setPath(normalizedPath);
        javaFile.parent = new JavaPackage();
        String directoryPath = normalizedPath != null && normalizedPath.contains("/") ? StringUtils.substringBeforeLast((String)normalizedPath, (String)"/") : "/";
        String normalizedParentPath = JavaFile.normalize((String)directoryPath);
        javaFile.parent.setKey(normalizedParentPath);
        javaFile.parent.setPath(normalizedParentPath);
        return javaFile;
    }

    public static JavaFile create(String relativePathFromBasedir, String relativePathFromSourceDir, boolean unitTest) {
        JavaFile javaFile = JavaFile.create(relativePathFromBasedir);
        if (relativePathFromSourceDir.contains("/")) {
            javaFile.packageFullyQualifiedName = StringUtils.substringBeforeLast((String)relativePathFromSourceDir, (String)"/");
            javaFile.packageFullyQualifiedName = StringUtils.replace((String)javaFile.packageFullyQualifiedName, (String)"/", (String)".");
            javaFile.filename = StringUtils.substringAfterLast((String)relativePathFromSourceDir, (String)"/");
            if (javaFile.filename.endsWith(JAVA_SUFFIX)) {
                javaFile.className = StringUtils.removeEndIgnoreCase((String)javaFile.filename, (String)JAVA_SUFFIX);
            } else if (javaFile.filename.endsWith(JAV_SUFFIX)) {
                javaFile.className = StringUtils.removeEndIgnoreCase((String)javaFile.filename, (String)JAV_SUFFIX);
            }
            javaFile.fullyQualifiedName = javaFile.packageFullyQualifiedName + "." + javaFile.className;
            javaFile.setDeprecatedKey(javaFile.fullyQualifiedName);
            javaFile.parent.setDeprecatedKey(Directory.parseKey((String)StringUtils.substringBeforeLast((String)relativePathFromSourceDir, (String)"/")));
        } else {
            javaFile.packageFullyQualifiedName = "[default]";
            javaFile.fullyQualifiedName = javaFile.className = StringUtils.removeEndIgnoreCase((String)relativePathFromSourceDir, (String)JAVA_SUFFIX);
            javaFile.setDeprecatedKey("[default]." + javaFile.className);
            javaFile.parent.setDeprecatedKey("[root]");
        }
        javaFile.unitTest = unitTest;
        return javaFile;
    }

    @Deprecated
    public static JavaFile fromRelativePath(String relativePath, boolean unitTest) {
        if (relativePath != null) {
            String pacname = null;
            String classname = relativePath;
            if (relativePath.indexOf(47) >= 0) {
                pacname = StringUtils.substringBeforeLast((String)relativePath, (String)"/");
                pacname = StringUtils.replace((String)pacname, (String)"/", (String)".");
                classname = StringUtils.substringAfterLast((String)relativePath, (String)"/");
            }
            classname = StringUtils.substringBeforeLast((String)classname, (String)".");
            return new JavaFile(pacname, classname, unitTest);
        }
        return null;
    }

    @Deprecated
    public static JavaFile fromIOFile(File file, List<File> sourceDirs, boolean unitTest) {
        if (file == null || !StringUtils.endsWithIgnoreCase((String)file.getName(), (String)JAVA_SUFFIX)) {
            return null;
        }
        PathResolver.RelativePath relativePath = new PathResolver().relativePath(sourceDirs, file);
        if (relativePath != null) {
            return JavaFile.fromRelativePath(relativePath.path(), unitTest);
        }
        return null;
    }

    @Deprecated
    public static JavaFile fromAbsolutePath(String path, List<File> sourceDirs, boolean unitTest) {
        if (path == null) {
            return null;
        }
        return JavaFile.fromIOFile(new File(path), sourceDirs, unitTest);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("deprecatedKey", (Object)this.getDeprecatedKey()).append("path", (Object)this.getPath()).append("filename", (Object)this.className).toString();
    }
}

