/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.util;

import org.apache.commons.lang.StringUtils;

public class DeprecatedKeyUtils {
    private DeprecatedKeyUtils() {
    }

    public static String getJavaFileParentDeprecatedKey(String deprecatedJavaFileKey) {
        String realKey = StringUtils.trim((String)deprecatedJavaFileKey);
        if (realKey.contains(".")) {
            String packageFullyQualifiedName = StringUtils.substringBeforeLast((String)realKey, (String)".");
            String deprecatedDirectoryKey = StringUtils.trimToEmpty((String)packageFullyQualifiedName);
            if ("[default]".equals(deprecatedDirectoryKey)) {
                return "[root]";
            }
            deprecatedDirectoryKey = deprecatedDirectoryKey.replaceAll("\\.", "/");
            return StringUtils.defaultIfEmpty((String)deprecatedDirectoryKey, (String)"[root]");
        }
        return "[root]";
    }

    public static String getJavaFileDeprecatedKey(String sourceRelativePath) {
        String pacname = null;
        String classname = sourceRelativePath;
        if (sourceRelativePath.indexOf(47) >= 0) {
            pacname = StringUtils.substringBeforeLast((String)sourceRelativePath, (String)"/");
            pacname = StringUtils.replace((String)pacname, (String)"/", (String)".");
            classname = StringUtils.substringAfterLast((String)sourceRelativePath, (String)"/");
        }
        classname = StringUtils.substringBeforeLast((String)classname, (String)".");
        if (StringUtils.isBlank((String)pacname)) {
            return "[default]" + "." + classname;
        }
        return pacname.trim() + "." + classname;
    }
}

