/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.symbol;

import com.google.common.collect.SortedSetMultimap;
import java.util.SortedSet;
import org.sonar.api.batch.sensor.symbol.Symbol;
import org.sonar.batch.index.Data;

public class SymbolData
implements Data {
    private static final String FIELD_SEPARATOR = ",";
    private static final String SYMBOL_SEPARATOR = ";";
    private final SortedSetMultimap<Symbol, Integer> referencesBySymbol;

    public SymbolData(SortedSetMultimap<Symbol, Integer> referencesBySymbol) {
        this.referencesBySymbol = referencesBySymbol;
    }

    public SortedSetMultimap<Symbol, Integer> referencesBySymbol() {
        return this.referencesBySymbol;
    }

    @Override
    public String writeString() {
        StringBuilder sb = new StringBuilder();
        for (Symbol symbol : this.referencesBySymbol.keySet()) {
            sb.append(symbol.getDeclarationStartOffset()).append(FIELD_SEPARATOR).append(symbol.getDeclarationEndOffset());
            SortedSet symbolReferences = this.referencesBySymbol.get((Object)symbol);
            for (Integer symbolReference : symbolReferences) {
                sb.append(FIELD_SEPARATOR).append(symbolReference);
            }
            sb.append(SYMBOL_SEPARATOR);
        }
        return sb.toString();
    }
}

