/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.symbol;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.Comparator;
import org.sonar.api.batch.sensor.symbol.Symbol;
import org.sonar.api.batch.sensor.symbol.SymbolTableBuilder;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbol;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.symbol.SymbolData;

public class DefaultSymbolTableBuilder
implements SymbolTableBuilder {
    private final String componentKey;
    private final ComponentDataCache cache;
    private final SortedSetMultimap<Symbol, Integer> referencesBySymbol;

    public DefaultSymbolTableBuilder(String componentKey, ComponentDataCache cache) {
        this.componentKey = componentKey;
        this.cache = cache;
        this.referencesBySymbol = TreeMultimap.create((Comparator)new SymbolComparator(), (Comparator)new ReferenceComparator());
    }

    public Symbol newSymbol(int fromOffset, int toOffset) {
        DefaultSymbol symbol = new DefaultSymbol(this.componentKey, fromOffset, toOffset);
        this.referencesBySymbol.put((Object)symbol, (Object)symbol.getDeclarationStartOffset());
        return symbol;
    }

    public void newReference(Symbol symbol, int fromOffset) {
        String otherComponentKey = ((DefaultSymbol)symbol).componentKey();
        if (!otherComponentKey.equals(this.componentKey)) {
            throw new UnsupportedOperationException("Cannot add reference from (" + this.componentKey + ") to another file (" + otherComponentKey + ")");
        }
        if (fromOffset >= symbol.getDeclarationStartOffset() && fromOffset < symbol.getDeclarationEndOffset()) {
            throw new UnsupportedOperationException("Cannot add reference (" + fromOffset + ") overlapping " + symbol);
        }
        this.referencesBySymbol.put((Object)symbol, (Object)fromOffset);
    }

    public void done() {
        SymbolData symbolData = new SymbolData(this.referencesBySymbol);
        this.cache.setData(this.componentKey, "symbol", symbolData);
    }

    public static class ReferenceComparator
    implements Comparator<Integer>,
    Serializable {
        @Override
        public int compare(Integer left, Integer right) {
            int result = left != null & right != null ? left - right : (left == null ? -1 : 1);
            return result;
        }
    }

    public static class SymbolComparator
    implements Comparator<Symbol>,
    Serializable {
        @Override
        public int compare(Symbol left, Symbol right) {
            return left.getDeclarationStartOffset() - right.getDeclarationStartOffset();
        }
    }
}

