/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.source;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.sonar.api.batch.sensor.symbol.Symbol;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.batch.symbol.DefaultSymbolTableBuilder;

public class DefaultSymbolTable
implements Symbolizable.SymbolTable {
    private SortedSetMultimap<Symbol, Integer> referencesBySymbol;

    private DefaultSymbolTable(SortedSetMultimap<Symbol, Integer> referencesBySymbol) {
        this.referencesBySymbol = referencesBySymbol;
    }

    public SortedSetMultimap<Symbol, Integer> getReferencesBySymbol() {
        return this.referencesBySymbol;
    }

    public List<org.sonar.api.source.Symbol> symbols() {
        ArrayList<org.sonar.api.source.Symbol> result = new ArrayList<org.sonar.api.source.Symbol>();
        for (Symbol symbol : this.referencesBySymbol.keySet()) {
            result.add((org.sonar.api.source.Symbol)symbol);
        }
        return result;
    }

    public List<Integer> references(org.sonar.api.source.Symbol symbol) {
        return new ArrayList<Integer>(this.referencesBySymbol.get((Object)symbol));
    }

    public static class Builder
    implements Symbolizable.SymbolTableBuilder {
        private final SortedSetMultimap<Symbol, Integer> referencesBySymbol;
        private final String componentKey;

        public Builder(String componentKey) {
            this.componentKey = componentKey;
            this.referencesBySymbol = TreeMultimap.create((Comparator)new DefaultSymbolTableBuilder.SymbolComparator(), (Comparator)new DefaultSymbolTableBuilder.ReferenceComparator());
        }

        public org.sonar.api.source.Symbol newSymbol(int fromOffset, int toOffset) {
            DefaultSymbol symbol = new DefaultSymbol(this.componentKey, fromOffset, toOffset);
            this.referencesBySymbol.put((Object)symbol, (Object)symbol.getDeclarationStartOffset());
            return symbol;
        }

        public void newReference(org.sonar.api.source.Symbol symbol, int fromOffset) {
            if (fromOffset >= symbol.getDeclarationStartOffset() && fromOffset < symbol.getDeclarationEndOffset()) {
                throw new UnsupportedOperationException("Cannot add reference (" + fromOffset + ") overlapping " + symbol);
            }
            this.referencesBySymbol.put((Object)symbol, (Object)fromOffset);
        }

        public Symbolizable.SymbolTable build() {
            return new DefaultSymbolTable(this.referencesBySymbol);
        }
    }
}

