/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.batch.bootstrap.BatchExtensionDictionnary;
import org.sonar.batch.scan2.AnalyzerOptimizer;

public class SensorsExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SensorsExecutor.class);
    private BatchExtensionDictionnary selector;
    private AnalyzerOptimizer optimizer;

    public SensorsExecutor(BatchExtensionDictionnary selector, AnalyzerOptimizer optimizer) {
        this.selector = selector;
        this.optimizer = optimizer;
    }

    public void execute(SensorContext context) {
        Collection<Sensor> analyzers = this.selector.select(Sensor.class, null, true, null);
        for (Sensor analyzer : analyzers) {
            DefaultSensorDescriptor descriptor = new DefaultSensorDescriptor();
            analyzer.describe((SensorDescriptor)descriptor);
            if (!this.optimizer.shouldExecute(descriptor)) continue;
            LOG.info("Execute sensor: " + descriptor.name());
            this.executeSensor(context, analyzer);
        }
    }

    private void executeSensor(SensorContext context, Sensor analyzer) {
        analyzer.execute(context);
    }
}

