/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectBootstrapper;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Languages;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.duplication.BlockCache;
import org.sonar.batch.duplication.DuplicationCache;
import org.sonar.batch.index.Caches;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.languages.DefaultLanguagesReferential;
import org.sonar.batch.profiling.PhasesSumUpTimeProfiler;
import org.sonar.batch.referential.DefaultProjectReferentialsLoader;
import org.sonar.batch.referential.ProjectReferentialsLoader;
import org.sonar.batch.referential.ProjectReferentialsProvider;
import org.sonar.batch.scan.ProjectReactorBuilder;
import org.sonar.batch.scan.ProjectSettings;
import org.sonar.batch.scan.filesystem.InputPathCache;
import org.sonar.batch.scan.maven.FakeMavenPluginExecutor;
import org.sonar.batch.scan.maven.MavenPluginExecutor;
import org.sonar.batch.scan2.AnalyzerIssueCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.batch.scan2.ModuleScanContainer;
import org.sonar.batch.scan2.ScanTaskObservers;

public class ProjectScanContainer
extends ComponentContainer {
    public ProjectScanContainer(ComponentContainer taskContainer) {
        super(taskContainer);
    }

    protected void doBeforeStart() {
        this.projectBootstrap();
        this.addBatchComponents();
        this.fixMavenExecutor();
        this.addBatchExtensions();
        Settings settings = (Settings)this.getComponentByType(Settings.class);
        if (settings != null && settings.getBoolean("sonar.showProfiling")) {
            this.add(new Object[]{PhasesSumUpTimeProfiler.class});
        }
    }

    private void projectBootstrap() {
        ProjectReactor reactor;
        ProjectBootstrapper bootstrapper = (ProjectBootstrapper)this.getComponentByType(ProjectBootstrapper.class);
        Settings settings = (Settings)this.getComponentByType(Settings.class);
        if (bootstrapper == null || "true".equals(settings.getString("sonar.mojoUseRunner"))) {
            ProjectReactorBuilder builder = (ProjectReactorBuilder)this.getComponentByType(ProjectReactorBuilder.class);
            reactor = builder.execute();
        } else {
            reactor = bootstrapper.bootstrap();
        }
        if (reactor == null) {
            throw new IllegalStateException(bootstrapper + " has returned null as ProjectReactor");
        }
        this.add(new Object[]{reactor});
        if (this.getComponentByType(ProjectReferentialsLoader.class) == null) {
            this.add(new Object[]{DefaultProjectReferentialsLoader.class});
        }
    }

    private void addBatchComponents() {
        this.add(new Object[]{new ProjectReferentialsProvider(), ProjectSettings.class, Caches.class, Languages.class, DefaultLanguagesReferential.class, AnalyzerMeasureCache.class, InputPathCache.class, PathResolver.class, AnalyzerIssueCache.class, ComponentDataCache.class, BlockCache.class, DuplicationCache.class, ScanTaskObservers.class});
    }

    private void fixMavenExecutor() {
        if (this.getComponentByType(MavenPluginExecutor.class) == null) {
            this.add(new Object[]{FakeMavenPluginExecutor.class});
        }
    }

    private void addBatchExtensions() {
        ((ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class)).install(this, new BatchExtensionFilter());
    }

    protected void doAfterStart() {
        ProjectReactor tree = (ProjectReactor)this.getComponentByType(ProjectReactor.class);
        this.scanRecursively(tree.getRoot());
        ((ScanTaskObservers)this.getComponentByType(ScanTaskObservers.class)).notifyEndOfScanTask();
    }

    private void scanRecursively(ProjectDefinition module) {
        for (ProjectDefinition subModules : module.getSubProjects()) {
            this.scanRecursively(subModules);
        }
        this.scan(module);
    }

    @VisibleForTesting
    void scan(ProjectDefinition module) {
        new ModuleScanContainer(this, module).execute();
    }

    static class BatchExtensionFilter
    implements ExtensionMatcher {
        BatchExtensionFilter() {
        }

        @Override
        public boolean accept(Object extension) {
            return ExtensionUtils.isType(extension, BatchComponent.class) && ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH");
        }
    }
}

