/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.batch.rule.QProfileVerifier;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.FileSystemLogger;
import org.sonar.batch.scan2.AnalysisPublisher;
import org.sonar.batch.scan2.SensorsExecutor;

public final class ModuleScanExecutor {
    private final SensorsExecutor analyzersExecutor;
    private final SensorContext analyzerContext;
    private final FileSystemLogger fsLogger;
    private final DefaultModuleFileSystem fs;
    private final QProfileVerifier profileVerifier;
    private final IssueExclusionsLoader issueExclusionsLoader;
    private AnalysisPublisher analyzisPublisher;

    public ModuleScanExecutor(SensorsExecutor analyzersExecutor, SensorContext analyzerContext, FileSystemLogger fsLogger, DefaultModuleFileSystem fs, QProfileVerifier profileVerifier, IssueExclusionsLoader issueExclusionsLoader, AnalysisPublisher analyzisPublisher) {
        this.analyzersExecutor = analyzersExecutor;
        this.analyzerContext = analyzerContext;
        this.fsLogger = fsLogger;
        this.fs = fs;
        this.profileVerifier = profileVerifier;
        this.issueExclusionsLoader = issueExclusionsLoader;
        this.analyzisPublisher = analyzisPublisher;
    }

    public static Collection<Class> getPhaseClasses() {
        return Lists.newArrayList((Object[])new Class[]{SensorsExecutor.class});
    }

    public void execute() {
        this.fsLogger.log();
        this.fs.index();
        this.profileVerifier.execute();
        this.issueExclusionsLoader.execute();
        this.analyzersExecutor.execute(this.analyzerContext);
        this.analyzisPublisher.execute();
    }
}

