/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.batch.bootstrap.BatchExtensionDictionnary;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.issue.IssuableFactory;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.batch.issue.ModuleIssues;
import org.sonar.batch.issue.ignore.EnforceIssuesFilter;
import org.sonar.batch.issue.ignore.IgnoreIssuesFilter;
import org.sonar.batch.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsRegexpScanner;
import org.sonar.batch.rule.ActiveRulesProvider;
import org.sonar.batch.rule.ModuleQProfiles;
import org.sonar.batch.rule.QProfileVerifier;
import org.sonar.batch.scan.LanguageVerifier;
import org.sonar.batch.scan.ModuleSettings;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.DeprecatedFileFilters;
import org.sonar.batch.scan.filesystem.ExclusionFilters;
import org.sonar.batch.scan.filesystem.FileIndexer;
import org.sonar.batch.scan.filesystem.FileSystemLogger;
import org.sonar.batch.scan.filesystem.InputFileBuilderFactory;
import org.sonar.batch.scan.filesystem.LanguageDetectionFactory;
import org.sonar.batch.scan.filesystem.ModuleFileSystemInitializer;
import org.sonar.batch.scan.filesystem.ModuleInputFileCache;
import org.sonar.batch.scan.filesystem.StatusDetectionFactory;
import org.sonar.batch.scan2.AnalysisPublisher;
import org.sonar.batch.scan2.AnalyzerOptimizer;
import org.sonar.batch.scan2.DefaultFileLinesContextFactory;
import org.sonar.batch.scan2.DefaultSensorContext;
import org.sonar.batch.scan2.ModuleScanExecutor;
import org.sonar.batch.scan2.ProjectScanContainer;

public class ModuleScanContainer
extends ComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleScanContainer.class);
    private final ProjectDefinition moduleDefinition;

    public ModuleScanContainer(ProjectScanContainer parent, ProjectDefinition moduleDefinition) {
        super((ComponentContainer)parent);
        this.moduleDefinition = moduleDefinition;
    }

    protected void doBeforeStart() {
        LOG.info("-------------  Scan {}", (Object)this.moduleDefinition.getName());
        this.addCoreComponents();
        this.addExtensions();
    }

    private void addCoreComponents() {
        this.add(new Object[]{this.moduleDefinition, ModuleSettings.class, EventBus.class, ModuleScanExecutor.class, ModuleScanExecutor.getPhaseClasses(), this.moduleDefinition.getContainerExtensions(), ModuleInputFileCache.class, FileExclusions.class, ExclusionFilters.class, DeprecatedFileFilters.class, InputFileBuilderFactory.class, StatusDetectionFactory.class, LanguageDetectionFactory.class, FileIndexer.class, LanguageVerifier.class, FileSystemLogger.class, DefaultModuleFileSystem.class, ModuleFileSystemInitializer.class, QProfileVerifier.class, AnalyzerOptimizer.class, DefaultSensorContext.class, BatchExtensionDictionnary.class, IssueFilters.class, ModuleQProfiles.class, new ActiveRulesProvider(), CheckFactory.class, IssuableFactory.class, ModuleIssues.class, DefaultFileLinesContextFactory.class, IssueInclusionPatternInitializer.class, IssueExclusionPatternInitializer.class, IssueExclusionsRegexpScanner.class, IssueExclusionsLoader.class, EnforceIssuesFilter.class, IgnoreIssuesFilter.class, AnalysisPublisher.class});
    }

    private void addExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class);
        installer.install(this, new ExtensionMatcher(){

            @Override
            public boolean accept(Object extension) {
                return ExtensionUtils.isType(extension, BatchComponent.class) && ExtensionUtils.isInstantiationStrategy(extension, "PER_PROJECT");
            }
        });
    }

    protected void doAfterStart() {
        ((ModuleScanExecutor)this.getComponentByType(ModuleScanExecutor.class)).execute();
    }
}

