/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRule;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.config.Settings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.duplication.BlockCache;
import org.sonar.batch.duplication.DuplicationCache;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.batch.scan.SensorContextAdaptor;
import org.sonar.batch.scan2.AnalyzerIssueCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.batch.scan2.BaseSensorContext;
import org.sonar.core.component.ComponentKeys;

public class DefaultSensorContext
extends BaseSensorContext {
    private final AnalyzerMeasureCache measureCache;
    private final AnalyzerIssueCache issueCache;
    private final ProjectDefinition def;
    private final ActiveRules activeRules;
    private final IssueFilters issueFilters;

    public DefaultSensorContext(ProjectDefinition def, AnalyzerMeasureCache measureCache, AnalyzerIssueCache issueCache, Settings settings, FileSystem fs, ActiveRules activeRules, IssueFilters issueFilters, ComponentDataCache componentDataCache, BlockCache blockCache, DuplicationCache duplicationCache) {
        super(settings, fs, activeRules, componentDataCache, blockCache, duplicationCache);
        this.def = def;
        this.measureCache = measureCache;
        this.issueCache = issueCache;
        this.activeRules = activeRules;
        this.issueFilters = issueFilters;
    }

    public Measure getMeasure(String metricKey) {
        return this.measureCache.byMetric(this.def.getKey(), this.def.getKey(), metricKey);
    }

    public <G extends Serializable> Measure<G> getMeasure(Metric<G> metric) {
        return this.measureCache.byMetric(this.def.getKey(), this.def.getKey(), metric.key());
    }

    public Measure getMeasure(InputFile file, String metricKey) {
        return this.measureCache.byMetric(this.def.getKey(), ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputPath)file), metricKey);
    }

    public <G extends Serializable> Measure<G> getMeasure(InputFile file, Metric<G> metric) {
        return this.measureCache.byMetric(this.def.getKey(), ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputPath)file), metric.key());
    }

    public void addMeasure(Measure<?> measure) {
        InputFile inputFile = measure.inputFile();
        if (inputFile != null) {
            this.measureCache.put(this.def.getKey(), ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputPath)inputFile), (DefaultMeasure)measure);
        } else {
            this.measureCache.put(this.def.getKey(), this.def.getKey(), (DefaultMeasure)measure);
        }
    }

    public boolean addIssue(Issue issue) {
        String resourceKey = issue.inputPath() != null ? ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputPath)issue.inputPath()) : this.def.getKey();
        RuleKey ruleKey = issue.ruleKey();
        DefaultActiveRule activeRule = (DefaultActiveRule)this.activeRules.find(ruleKey);
        if (activeRule == null) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)activeRule.name()) && Strings.isNullOrEmpty((String)issue.message())) {
            throw MessageException.of((String)String.format("The rule '%s' has no name and the related issue has no message.", ruleKey));
        }
        this.updateIssue((DefaultIssue)issue, activeRule);
        if (this.issueFilters.accept(SensorContextAdaptor.toDefaultIssue(this.def.getKey(), resourceKey, issue), null)) {
            this.issueCache.put(this.def.getKey(), resourceKey, (DefaultIssue)issue);
            return true;
        }
        return false;
    }

    private void updateIssue(DefaultIssue issue, DefaultActiveRule activeRule) {
        if (Strings.isNullOrEmpty((String)issue.message())) {
            issue.setMessage(activeRule.name());
        }
        if (issue.severity() == null) {
            issue.setSeverity(activeRule.severity());
        }
    }
}

