/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.duplication.DuplicationBuilder;
import org.sonar.api.batch.sensor.duplication.DuplicationGroup;
import org.sonar.api.batch.sensor.duplication.DuplicationTokenBuilder;
import org.sonar.api.batch.sensor.duplication.internal.DefaultDuplicationBuilder;
import org.sonar.api.batch.sensor.highlighting.HighlightingBuilder;
import org.sonar.api.batch.sensor.issue.IssueBuilder;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueBuilder;
import org.sonar.api.batch.sensor.measure.MeasureBuilder;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasureBuilder;
import org.sonar.api.batch.sensor.symbol.SymbolTableBuilder;
import org.sonar.api.config.Settings;
import org.sonar.batch.duplication.BlockCache;
import org.sonar.batch.duplication.DefaultTokenBuilder;
import org.sonar.batch.duplication.DuplicationCache;
import org.sonar.batch.highlighting.DefaultHighlightingBuilder;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.symbol.DefaultSymbolTableBuilder;
import org.sonar.duplications.internal.pmd.PmdBlockChunker;

public abstract class BaseSensorContext
implements SensorContext {
    private final Settings settings;
    private final FileSystem fs;
    private final ActiveRules activeRules;
    private final ComponentDataCache componentDataCache;
    private final BlockCache blockCache;
    private final DuplicationCache duplicationCache;

    protected BaseSensorContext(Settings settings, FileSystem fs, ActiveRules activeRules, ComponentDataCache componentDataCache, BlockCache blockCache, DuplicationCache duplicationCache) {
        this.settings = settings;
        this.fs = fs;
        this.activeRules = activeRules;
        this.componentDataCache = componentDataCache;
        this.blockCache = blockCache;
        this.duplicationCache = duplicationCache;
    }

    public Settings settings() {
        return this.settings;
    }

    public FileSystem fileSystem() {
        return this.fs;
    }

    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public <G extends Serializable> MeasureBuilder<G> measureBuilder() {
        return new DefaultMeasureBuilder();
    }

    public IssueBuilder issueBuilder() {
        return new DefaultIssueBuilder();
    }

    public HighlightingBuilder highlightingBuilder(InputFile inputFile) {
        return new DefaultHighlightingBuilder(((DefaultInputFile)inputFile).key(), this.componentDataCache);
    }

    public SymbolTableBuilder symbolTableBuilder(InputFile inputFile) {
        return new DefaultSymbolTableBuilder(((DefaultInputFile)inputFile).key(), this.componentDataCache);
    }

    public DuplicationTokenBuilder duplicationTokenBuilder(InputFile inputFile) {
        PmdBlockChunker blockChunker = new PmdBlockChunker(this.getBlockSize(inputFile.language()));
        return new DefaultTokenBuilder(inputFile, this.blockCache, blockChunker);
    }

    public DuplicationBuilder duplicationBuilder(InputFile inputFile) {
        return new DefaultDuplicationBuilder(inputFile);
    }

    public void saveDuplications(InputFile inputFile, List<DuplicationGroup> duplications) {
        Preconditions.checkState((!duplications.isEmpty() ? 1 : 0) != 0, (Object)"Empty duplications");
        String effectiveKey = ((DefaultInputFile)inputFile).key();
        for (DuplicationGroup duplicationGroup : duplications) {
            Preconditions.checkState((boolean)effectiveKey.equals(duplicationGroup.originBlock().resourceKey()), (Object)"Invalid duplication group");
        }
        this.duplicationCache.put(effectiveKey, duplications);
    }

    private int getBlockSize(String languageKey) {
        int blockSize = this.settings.getInt("sonar.cpd." + languageKey + ".minimumLines");
        if (blockSize == 0) {
            blockSize = BaseSensorContext.getDefaultBlockSize(languageKey);
        }
        return blockSize;
    }

    private static int getDefaultBlockSize(String languageKey) {
        if ("cobol".equals(languageKey)) {
            return 30;
        }
        if ("abap".equals(languageKey) || "natur".equals(languageKey)) {
            return 20;
        }
        return 10;
    }
}

